package dev.felnull.otyacraftengine.client.renderer.texture;

import dev.felnull.otyacraftengine.client.util.OETextureUtils;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public interface TextureLoadResult {
    class_2960 getLocation();

    boolean isLoading();

    boolean isError();

    boolean isSuccess();

    Throwable getThrowable();

    @NotNull
    default class_2960 of(@NotNull class_2960 loadingLocation, @NotNull class_2960 errorlLocation) {
        if (isLoading()) return loadingLocation;
        if (isError()) return errorlLocation;
        return getLocation();
    }

    @NotNull
    default class_2960 of(@NotNull class_2960 errorLocation) {
        return of(OETextureUtils.getLoadingIcon(), errorLocation);
    }

    @NotNull
    default class_2960 of() {
        return of(OETextureUtils.getLoadingIcon(), OETextureUtils.getErrorIcon());
    }

    TextureLoadProgress getProgress();
}
