package dev.felnull.otyacraftengine.fabric.tag;

import com.google.common.base.Suppliers;
import dev.felnull.otyacraftengine.data.provider.TagProviderWrapper;
import dev.felnull.otyacraftengine.tag.ManualTagHolder;
import net.fabricmc.fabric.impl.tag.convention.TagRegistration;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class OEFabricItemTags {
    public static final Supplier<ManualTagHolder<class_1792>> IRON_NUGGETS = bind("iron_nuggets", tp -> tp.add(class_1802.field_8675));
    public static final Supplier<ManualTagHolder<class_1792>> ENDER_PEARLS = bind("ender_pearls", tp -> tp.add(class_1802.field_8634));
    public static final Supplier<ManualTagHolder<class_1792>> STONE = bind("stone", tp -> {
        tp.add(class_1802.field_20391, class_1802.field_20407, class_1802.field_20401, class_1802.field_20394, class_1802.field_28866);
        tp.add(class_1802.field_20411, class_1802.field_20403, class_1802.field_20397, class_1802.field_28871);
    });
    public static final Supplier<ManualTagHolder<class_1792>> REDSTONE_BLOCKS = bind("redstone_blocks", tp -> tp.add(class_1802.field_8793));
    public static final Supplier<class_6862<class_1792>> BOOKS = bind("books");
    public static final Supplier<ManualTagHolder<class_1792>> RAW_MEATS = bind("raw_meats", tp -> tp.add(class_1802.field_8046, class_1802.field_8389, class_1802.field_8726, class_1802.field_8748, class_1802.field_8504).addOptionalTag(cLoc("raw_meat")));
    public static final Supplier<ManualTagHolder<class_1792>> COOKED_MEATS = bind("cooked_meats", tp -> tp.add(class_1802.field_8176, class_1802.field_8261, class_1802.field_8544, class_1802.field_8347, class_1802.field_8752).addOptionalTag(cLoc("cooked_meat")));
    public static final Supplier<ManualTagHolder<class_1792>> RAW_FISHES = bind("raw_fishes", tp -> tp.add(class_1802.field_8429, class_1802.field_8209, class_1802.field_8846, class_1802.field_8323).addOptionalTag(cLoc("raw_fish")));
    public static final Supplier<ManualTagHolder<class_1792>> COOKED_FISHES = bind("cooked_fishes", tp -> tp.add(class_1802.field_8373, class_1802.field_8509).addOptionalTag(cLoc("cooked_fish")));
    public static final Supplier<ManualTagHolder<class_1792>> WHEAT_BREADS = bind("wheat_breads", tp -> tp.add(class_1802.field_8229).addOptionalTag(cLoc("bread/wheat")));
    public static final Supplier<ManualTagHolder<class_1792>> BREADS = bind("breads", tp -> tp.addTag(WHEAT_BREADS.get()).addOptionalTag(cLoc("bread")));
    public static final Supplier<ManualTagHolder<class_1792>> VEGETABLES = bind("vegetables", tp -> tp.add(class_1802.field_8179, class_1802.field_8567, class_1802.field_8186));
    public static final Supplier<ManualTagHolder<class_1792>> CARROTS = bind("carrots", tp -> tp.add(class_1802.field_8179));
    public static final Supplier<ManualTagHolder<class_1792>> POTATOES = bind("potatoes", tp -> tp.add(class_1802.field_8567));
    public static final Supplier<ManualTagHolder<class_1792>> BEETROOTS = bind("beetroots", tp -> tp.add(class_1802.field_8186));


    private static Supplier<ManualTagHolder<class_1792>> bind(String id, Consumer<TagProviderWrapper.TagAppenderWrapper<class_1792>> tagRegister) {
        return Suppliers.memoize(() -> ManualTagHolder.of(TagRegistration.ITEM_TAG_REGISTRATION.registerCommon(id), tagRegister));
    }

    private static Supplier<class_6862<class_1792>> bind(String id) {
        return Suppliers.memoize(() -> TagRegistration.ITEM_TAG_REGISTRATION.registerCommon(id));
    }

    private static class_2960 cLoc(String path) {
        return new class_2960("c", path);
    }
}
