package dev.felnull.otyacraftengine.inventory;

import com.mojang.datafixers.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3917;

public abstract class OEBaseMenu extends class_1703 {
    private final class_1661 playerInventory;
    private final class_1263 container;

    protected OEBaseMenu(@Nullable class_3917<?> menuType, int i, class_1661 playerInventory, class_1263 container, int playerSlotX, int playerSlotY) {
        super(menuType, i);
        this.playerInventory = playerInventory;
        this.container = container;
        setSlot();
        setPlayerSlot(playerSlotX, playerSlotY);
    }

    protected abstract void setSlot();

    @Override
    public boolean method_7597(class_1657 player) {
        return this.container.method_5443(player);
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.container.method_5432(player);
    }

    protected boolean isActiveOffHandSlot() {
        return false;
    }

    public class_1263 getContainer() {
        return container;
    }

    protected void setPlayerSlot(int x, int y) {
        if (x >= 0 && y >= 0) {
            IntStream.range(0, 3).forEach(k -> IntStream.range(0, 9).forEach(i1 -> this.method_7621(new class_1735(playerInventory, i1 + k * 9 + 9, x + i1 * 18, y + k * 18))));
            IntStream.range(0, 9).forEach(l -> this.method_7621(new class_1735(playerInventory, l, x + l * 18, y + 58)));
            if (isActiveOffHandSlot())
                this.method_7621(new class_1735(playerInventory, class_1661.field_30639, x + 166, y + 58) {
                    @Override
                    public @NotNull Pair<class_2960, class_2960> method_7679() {
                        return Pair.of(class_1723.field_21668, class_1723.field_21673);
                    }
                });
        }
    }

    public class_1661 getPlayerInventory() {
        return playerInventory;
    }

    @Override
    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemstack = class_1799.field_8037;
        class_1735 slot = this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 slotitem = slot.method_7677();
            itemstack = slotitem.method_7972();
            if (index <= getNonPlayerInventorySlotCount() - 1) {
                if (!this.method_7616(slotitem, getNonPlayerInventorySlotCount(), 36 + getNonPlayerInventorySlotCount(), false)) {
                    return class_1799.field_8037;
                }
            } else if (index <= getNonPlayerInventorySlotCount() + 26) {
                for (int i = 0; i < getNonPlayerInventorySlotCount(); i++) {
                    if (getNonPlayerInventorySlots().get(i).method_7680(slotitem) && !this.method_7616(slotitem, i, i + 1, false)) {
                        return class_1799.field_8037;
                    }
                }
                if (!this.method_7616(slotitem, getNonPlayerInventorySlotCount() + 27, getNonPlayerInventorySlotCount() + 36, false)) {
                    return class_1799.field_8037;
                }
            } else {
                for (int i = 0; i < getNonPlayerInventorySlotCount(); i++) {
                    if (getNonPlayerInventorySlots().get(i).method_7680(slotitem) && !this.method_7616(slotitem, i, i + 1, false)) {
                        return class_1799.field_8037;
                    }
                }
                if (!this.method_7616(slotitem, getNonPlayerInventorySlotCount(), getNonPlayerInventorySlotCount() + 26, false)) {
                    return class_1799.field_8037;
                }
            }
            if (slotitem.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (slotitem.method_7947() == itemstack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, slotitem);
        }
        return itemstack;
    }

    public int getNonPlayerInventorySlotCount() {
        return getNonPlayerInventorySlots().size();
    }

    public List<class_1735> getNonPlayerInventorySlots() {
        return field_7761.stream().filter(n -> n.field_7871 != getPlayerInventory()).collect(Collectors.toList());
    }

    abstract public boolean isBlock();
}
