package dev.felnull.otyacraftengine.item.location;

import dev.felnull.otyacraftengine.item.location.factory.PlayerItemLocationFactory;

public record HandItemLocation(InteractionHand hand) implements PlayerItemLocation {
    @Override
    public ItemStack getItem(Player player) {
        return player.getItemInHand(hand);
    }

    @Override
    public CompoundTag createTag() {
        var tag = new CompoundTag();
        tag.putBoolean("hand", hand == InteractionHand.MAIN_HAND);
        return tag;
    }

    @Override
    public PlayerItemLocationFactory<? extends PlayerItemLocation> getFactory() {
        return PlayerItemLocations.HAND_ITEM;
    }
}
