/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.data.provider;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.provider.DevToolProviderWrapper;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNDataUtil;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNStringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_7403;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ModelDivisionProviderWrapper
extends DevToolProviderWrapper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public ModelDivisionProviderWrapper(CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(crossDataGeneratorAccess);
    }

    protected abstract boolean isTarget(Path var1, Path var2);

    @Override
    public void run(class_7403 cachedOutput) throws IOException {
        ArrayList results = new ArrayList();
        Path outPath = this.getGenerator().method_10313();
        Collection<Path> inPaths = this.getCrossGeneratorAccess().getResourceInputFolders();
        for (Path path : inPaths) {
            Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);
            try {
                walk.forEach(tp -> {
                    if (!Files.isDirectory(tp, new LinkOption[0]) && this.isTarget(path, (Path)tp)) {
                        results.add(CompletableFuture.supplyAsync(() -> this.task(outPath, path, (Path)tp), class_156.method_18349()));
                    }
                });
            }
            finally {
                if (walk == null) continue;
                walk.close();
            }
        }
        for (CompletableFuture result : results) {
            try {
                List ret = (List)result.get();
                for (EntryResult entryResult : ret) {
                    cachedOutput.method_43346(entryResult.path, entryResult.data, entryResult.hash);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private List<EntryResult> task(Path outPath, Path inPath, Path path) {
        JsonObject model;
        Path rp = inPath.relativize(path);
        Path op = outPath.resolve(rp);
        try (FileReader reader = new FileReader(path.toFile());
             BufferedReader bufReader = new BufferedReader(reader);){
            model = (JsonObject)GSON.fromJson((Reader)bufReader, JsonObject.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.divModel(FNStringUtil.removeExtension(op.toFile().getName()), model).entrySet().stream().map(ret -> {
            HashCode hashCode;
            byte[] bs;
            String name = (String)ret.getKey();
            Path divOutPath = op.getParent().resolve(FNStringUtil.escapeFileName(name, "_") + ".json");
            JsonObject divModel = this.processModel(path, divOutPath, name, (JsonObject)ret.getValue());
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                 HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteArrayOutputStream);
                 ByteArrayInputStream stream = new ByteArrayInputStream(GSON.toJson((JsonElement)divModel).getBytes(StandardCharsets.UTF_8));){
                FNDataUtil.i2o(stream, (OutputStream)hashingOutputStream);
                bs = byteArrayOutputStream.toByteArray();
                hashCode = hashingOutputStream.hash();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new EntryResult(divOutPath, bs, hashCode);
        }).toList();
    }

    protected JsonObject processModel(Path orizinalPath, Path divOutPath, String groupName, JsonObject model) {
        return model;
    }

    protected Map<String, JsonObject> divModel(String name, JsonObject original) {
        JsonArray groups = original.getAsJsonArray("groups");
        if (groups == null) {
            return ImmutableMap.of((Object)name, (Object)original);
        }
        HashMap divGroups = new HashMap();
        for (JsonElement group : groups) {
            JsonObject jsonObject;
            if (group instanceof JsonObject && (jsonObject = (JsonObject)group).has("name") && this.isDivGroup(jsonObject.get("name").getAsString())) {
                String gname = this.convertDivGroupName(jsonObject.get("name").getAsString());
                divGroups.putIfAbsent(gname, new ArrayList());
                ((List)divGroups.get(gname)).add(group);
                continue;
            }
            divGroups.putIfAbsent(name, new ArrayList());
            ((List)divGroups.get(name)).add(group);
        }
        JsonArray orelement = original.getAsJsonArray("elements");
        return divGroups.entrySet().stream().map(ent -> Pair.of((Object)((String)ent.getKey()), ((List)ent.getValue()).stream().flatMap(r -> this.getAllChildren((JsonElement)r).stream()).toList())).map(ent -> {
            JsonObject oriCopy = original.deepCopy();
            oriCopy.remove("elements");
            oriCopy.remove("groups");
            JsonArray nelements = new JsonArray();
            for (Integer integer : (List)ent.getRight()) {
                nelements.add(orelement.get(integer.intValue()));
            }
            oriCopy.add("elements", (JsonElement)nelements);
            return Pair.of((Object)((String)ent.getLeft()), (Object)oriCopy);
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    protected boolean isChildDir(Path inputFolder, Path path, Path targetPath) {
        Path rp = inputFolder.relativize(path);
        String rps = rp.toString().replace("\\", "/");
        String tps = targetPath.toString().replace("\\", "/");
        return rps.startsWith(tps);
    }

    protected boolean isDivGroup(String groupName) {
        return groupName.startsWith("_");
    }

    protected String convertDivGroupName(String groupName) {
        return groupName.substring(1);
    }

    private List<Integer> getAllChildren(JsonElement group) {
        JsonPrimitive jsonPrimitive;
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (group instanceof JsonObject) {
            JsonObject groupJson = (JsonObject)group;
            JsonArray children = groupJson.getAsJsonArray("children");
            for (JsonElement child : children) {
                ret.addAll(this.getAllChildren(child));
            }
        } else if (group instanceof JsonPrimitive && (jsonPrimitive = (JsonPrimitive)group).isNumber()) {
            ret.add(jsonPrimitive.getAsInt());
        }
        return ret;
    }

    @Override
    public String getName() {
        return "Model Division";
    }

    private record EntryResult(Path path, byte[] data, HashCode hash) {
    }
}

