package dev.felnull.otyacraftengine.advancement;

import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.util.OEItemUtils;
import net.minecraft.advancements.critereon.*;
import net.minecraft.class_1799;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5267;
import org.jetbrains.annotations.NotNull;

public class ModInvolvementTrigger extends class_4558<ModInvolvementTrigger.TriggerInstance> {
    static final class_2960 ID = new class_2960(OtyacraftEngine.MODID, "mod_involvement");

    @Override
    public class_2960 method_794() {
        return ID;
    }

    @Override
    protected TriggerInstance method_27854(JsonObject jsonObject, class_2048.@NotNull class_5258 composite, @NotNull class_5257 deserializationContext) {
        String mid = jsonObject.has("modid") ? jsonObject.get("modid").getAsString() : "";
        return new TriggerInstance(composite, mid);
    }

    public static void trigger(class_3222 serverPlayer, class_1799 itemStack) {
        OECriteriaTriggers.MOD_INVOLVEMENT_TRIGGER.trigger_(serverPlayer, itemStack);
    }

    public static void trigger(class_3222 serverPlayer, String modId) {
        OECriteriaTriggers.MOD_INVOLVEMENT_TRIGGER.trigger_(serverPlayer, modId);
    }

    private void trigger_(class_3222 serverPlayer, class_1799 itemStack) {
        this.method_22510(serverPlayer, (triggerInstance) -> triggerInstance.matches(itemStack));
    }

    private void trigger_(class_3222 serverPlayer, String modId) {
        this.method_22510(serverPlayer, (triggerInstance) -> triggerInstance.matches(modId));
    }

    public static class TriggerInstance extends class_195 {
        @NotNull
        private final String modId;

        public TriggerInstance(class_2048.class_5258 composite, @NotNull String modId) {
            super(ID, composite);
            this.modId = modId;
        }

        public static TriggerInstance involvedMod(String modId) {
            return new TriggerInstance(class_2048.class_5258.field_24388, modId);
        }

        private boolean matches(class_1799 stack) {
            var id = OEItemUtils.getCreatorModId(stack);
            return matches(id);
        }

        private boolean matches(String modId) {
            return this.modId.equals(modId);
        }

        @Override
        public JsonObject method_807(@NotNull class_5267 serializationContext) {
            var jo = super.method_807(serializationContext);
            jo.addProperty("modid", modId);
            return jo;
        }
    }
}
