package dev.felnull.otyacraftengine.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.felnull.otyacraftengine.client.gui.TextureSpecify;
import dev.felnull.otyacraftengine.client.gui.components.base.OEBaseImageWidget;
import dev.felnull.otyacraftengine.client.util.OEClientUtils;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;

/**
 * 固定リストウィジェット<br>
 * 複数のエントリーから一つを選択させたい場合などに利用<br>
 *
 * <img alt="FixedList" src="https://cdn.discordapp.com/attachments/523502209988821033/1038406259084378112/2022-11-05_19h55_29.png">
 *
 * @param <E>
 */
public abstract class FixedListWidget<E> extends OEBaseImageWidget {
    private static final TextureSpecify DEFAULT_TEXTURE = TextureSpecify.createRelative(WIDGETS, 40, 34, 18, 42);
    @NotNull
    private List<E> entryList;
    @NotNull
    private final Function<E, class_2561> entryName;
    @Nullable
    private final PressEntry<E> onPressEntry;
    private final boolean selectable;
    private final int entryShowCount;
    private boolean border;
    private float scrollAmount;
    private boolean canScroll;
    protected boolean isHoveredScrollBar;
    protected int hoveredNumber;
    @Nullable
    protected E selectedEntry;
    protected int selectedEntryIndex = -1;

    /**
     * @param x              X座標
     * @param y              Y座標
     * @param width          横幅
     * @param height         高さ
     * @param message        メッセージ
     * @param entryShowCount エントリーを表示数
     * @param entryList      エントリーのリスト
     * @param entryName      エントリーから名前を取得
     * @param onPressEntry   エントリーを押下
     * @param selectable     選択を有効にするかどうか
     * @param old            コピー用の古い値
     */
    public FixedListWidget(int x, int y, int width, int height, @NotNull class_2561 message, int entryShowCount, @NotNull List<E> entryList, @NotNull Function<E, class_2561> entryName, @Nullable PressEntry<E> onPressEntry, boolean selectable, @Nullable FixedListWidget<E> old) {
        this(x, y, width, height, message, entryShowCount, entryList, entryName, onPressEntry, selectable, DEFAULT_TEXTURE, old);
    }

    /**
     * @param x              X座標
     * @param y              Y座標
     * @param width          横幅
     * @param height         高さ
     * @param message        メッセージ
     * @param entryShowCount エントリーを表示数
     * @param entryList      エントリーのリスト
     * @param entryName      エントリーから名前を取得
     * @param onPressEntry   エントリーを押下
     * @param selectable     選択を有効にするかどうか
     * @param texture        テクスチャ
     * @param old            コピー用の古い値
     */
    public FixedListWidget(int x, int y, int width, int height, @NotNull class_2561 message, int entryShowCount, @NotNull List<E> entryList, @NotNull Function<E, class_2561> entryName, @Nullable PressEntry<E> onPressEntry, boolean selectable, @NotNull TextureSpecify texture, @Nullable FixedListWidget<E> old) {
        super(x, y, width, height, "fixedListWidget", message, texture);
        this.entryShowCount = entryShowCount;
        this.entryList = entryList;
        this.entryName = entryName;
        this.onPressEntry = onPressEntry;
        this.selectable = selectable;
        copyValue(old);
    }

    @Override
    public void method_25394(@NotNull class_4587 poseStack, int mx, int my, float parTick) {
        if (this.field_22764) {
            this.hoveredNumber = (my - method_46427()) / getIndividualHeight();
            this.isHoveredScrollBar = mx >= this.method_46426() + getIndividualWidth() && my >= this.method_46427() && mx < this.method_46426() + this.field_22758 && my < this.method_46427() + this.field_22759;
        }
        super.method_25394(poseStack, mx, my, parTick);
    }

    @Override
    public void method_25359(@NotNull class_4587 poseStack, int mx, int my, float parTick) {
        for (int i = 0; i < entryShowCount; i++) {
            int cn = getCurrentFirstEntryIndex() + i;
            if (cn >= entryList.size() || cn < 0)
                break;
            var e = entryList.get(cn);
            renderOneButton(poseStack, e, cn, i, method_46426(), method_46427() + getIndividualHeight() * i, mx, my, parTick, selectedEntry == entryList.get(cn));
        }
        renderScrollbar(poseStack, this.method_46426() + getIndividualWidth(), this.method_46427(), 9, field_22759);
    }

    protected void renderScrollbar(class_4587 poseStack, int x, int y, int w, int h) {
        boolean hv = isScrollBarHovered() || method_25370();

        OERenderUtils.drawTexture(texture.getTextureLocation(), poseStack, x, y, texture.getU0() + (hv ? 9 : 0), texture.getV0(), 9, 3, texture.getTextureWidth(), texture.getTextureHeight());
        int bsct = (field_22759 - 6) / 16;
        for (int i = 0; i < bsct; i++) {
            OERenderUtils.drawTexture(texture.getTextureLocation(), poseStack, x, y + 3 + (i * 16), texture.getU0() + (hv ? 9 : 0), texture.getV0() + 3, 9, 16, texture.getTextureWidth(), texture.getTextureHeight());
        }
        int bsam = (field_22759 - 6) % 16;
        OERenderUtils.drawTexture(texture.getTextureLocation(), poseStack, x, y + 3 + (bsct * 16), texture.getU0() + (hv ? 9 : 0), texture.getV0() + 3, 9, bsam, texture.getTextureWidth(), texture.getTextureHeight());
        OERenderUtils.drawTexture(texture.getTextureLocation(), poseStack, x, y + field_22759 - 3, texture.getU0() + (hv ? 9 : 0), texture.getV0() + 19, 9, 3, texture.getTextureWidth(), texture.getTextureHeight());

        int barHeight = getBarHeight();
        float barY = (getActualHeight() - barHeight) * scrollAmount;

        OERenderUtils.drawTexture(texture.getTextureLocation(), poseStack, x + 1, y + 1 + barY, texture.getU0() + (hv ? 7 : 0), texture.getV0() + 22, 7, 3, texture.getTextureWidth(), texture.getTextureHeight());
        int ssct = (barHeight - 6) / 14;
        for (int i = 0; i < ssct; i++) {
            OERenderUtils.drawTexture(texture.getTextureLocation(), poseStack, x + 1, y + 4 + (i * 14) + barY, texture.getU0() + (hv ? 7 : 0), texture.getV0() + 25, 7, 14, texture.getTextureWidth(), texture.getTextureHeight());
        }
        int ssam = (barHeight - 6) % 14;
        OERenderUtils.drawTexture(texture.getTextureLocation(), poseStack, x + 1, y + 4 + (ssct * 14) + barY, texture.getU0() + (hv ? 7 : 0), texture.getV0() + 25, 7, ssam, texture.getTextureWidth(), texture.getTextureHeight());
        OERenderUtils.drawTexture(texture.getTextureLocation(), poseStack, x + 1, y + 1 + barHeight - 3 + barY, texture.getU0() + (hv ? 7 : 0), texture.getV0() + 39, 7, 3, texture.getTextureWidth(), texture.getTextureHeight());
    }

    protected void renderOneButton(class_4587 poseStack, E item, int lnum, int bnum, int bX, int bY, int mx, int my, float parTick, boolean selected) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture(0, field_22757);
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, this.field_22765);
        int k = this.method_25356(this.isEntryHovered(bnum));
        if (selected) k = 0;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        this.method_25302(poseStack, bX, bY, 0, 46 + k * 20, getIndividualWidth() / 2, getIndividualHeight());
        this.method_25302(poseStack, bX + getIndividualWidth() / 2, bY, 200 - getIndividualWidth() / 2, 46 + k * 20, getIndividualWidth() / 2, getIndividualHeight());
        this.method_25353(poseStack, mc, mx, my);

        int l = this.field_22763 ? 16777215 : 10526880;
        method_27534(poseStack, mc.field_1772, this.getMessage(lnum), this.method_46426() + getIndividualWidth() / 2, bY + (getIndividualHeight() - 8) / 2, l | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
        // drawCenteredString(poseStack, mc.font, this.getMessage(lnum), this.x + getIndividualWidth() / 2, y + (getIndividualHeight() - 8) / 2, l | Mth.ceil(this.alpha * 255.0F) << 24);
    }

    @Override
    public void onPress() {

    }

    @Override
    public void method_25354(@NotNull class_1144 soundManager) {
        boolean flg = isEntryHovered(hoveredNumber);
        boolean nflg = entryList.size() > hoveredNumber;
        if (!(flg && !nflg))
            super.method_25354(soundManager);
    }

    @Override
    public void method_25348(double mx, double my) {
        onPress((int) ((my - method_46427()) / getIndividualHeight()));
        super.method_25348(mx, my);
    }

    @Override
    public boolean method_25403(double mx, double my, int i, double f, double g) {
        scroll(my);
        return super.method_25403(mx, my, i, f, g);
    }

    @Override
    public boolean method_25402(double mx, double my, int i) {
        canScroll = isScrollBarHovered();
        scroll(my);
        return super.method_25402(mx, my, i);
    }

    @Override
    public boolean method_25401(double d, double e, double f) {
        this.setScrollAmount(this.getScrollAmount() - getMouseScrollAmount(f));
        return true;
    }

    @Override
    public boolean method_25404(int i, int j, int k) {
        if (this.field_22763 && this.field_22764 && method_25367()) {
            if (i == GLFW.GLFW_KEY_UP) {
                this.setScrollAmount(this.getScrollAmount() - 0.3f * ((float) entryShowCount / (float) field_22759));
                return true;
            } else if (i == GLFW.GLFW_KEY_DOWN) {
                this.setScrollAmount(this.getScrollAmount() + 0.3f * ((float) entryShowCount / (float) field_22759));
                return true;
            }
        }
        return false;
    }

    public void onPress(int num) {
        int cn = getCurrentFirstEntryIndex() + num;
        if (cn < entryList.size() && isEntryHovered(num)) {
            var e = entryList.get(cn);
            if (selectable) {
                selectedEntry = e;
                selectedEntryIndex = cn;
            }
            if (onPressEntry != null)
                onPressEntry.onPressEntry(this, e);
        }
    }

    public void setSelectedEntry(int index) {
        if (index >= 0 && index < entryList.size()) {
            this.selectedEntry = entryList.get(index);
            this.selectedEntryIndex = index;
        } else {
            this.selectedEntry = null;
            this.selectedEntryIndex = -1;
        }
    }

    public void setSelectedEntry(@Nullable E selectedEntry) {
        if (selectedEntry == null || entryList.stream().anyMatch(n -> n == selectedEntry)) {
            this.selectedEntry = selectedEntry;
            if (selectedEntry == null)
                selectedEntryIndex = -1;
            else
                selectedEntryIndex = entryList.indexOf(selectedEntry);
        }
    }

    public @Nullable
    E getSelectedEntry() {
        if (entryList.stream().anyMatch(n -> n == selectedEntry))
            return selectedEntry;
        return null;
    }

    public int getSelectedEntryIndex() {
        if (getSelectedEntry() == null) return -1;
        return selectedEntryIndex;
    }

    protected int getCurrentFirstEntryIndex() {
        if (entryList.size() <= entryShowCount)
            return 0;
        return (int) ((entryList.size() - entryShowCount) * scrollAmount);
    }

    public boolean isEntryHovered(int lnum) {
        return this.field_22762 && hoveredNumber == lnum && !isHoveredScrollBar;
    }

    public boolean isScrollBarHovered() {
        return this.field_22762 && this.isHoveredScrollBar;
    }

    public class_2561 getMessage(int index) {
        return entryName.apply(entryList.get(index));
    }

    public void scroll(double mouseY) {
        if (canScroll) {
            int cy = (int) (mouseY - this.method_46427() - 1 - getBarHeight() / 2);
            int sa = getActualHeight() - getBarHeight();
            if (sa > 0) {
                setScrollAmount((float) cy / (float) sa);
            }
        }
    }

    public int getBarHeight() {
        return class_3532.method_15340((int) (getActualHeight() / (((float) entryList.size() / (float) entryShowCount))), 10, getActualHeight());
    }

    public float getScrollAmount() {
        return scrollAmount;
    }

    public void setScrollAmount(float scrollAmount) {
        this.scrollAmount = class_3532.method_15363(scrollAmount, 0f, 1f);
    }

    public int getActualHeight() {
        return field_22759 - 2;
    }

    public int getIndividualHeight() {
        return field_22759 / entryShowCount;
    }

    public int getIndividualWidth() {
        return field_22758 - (9 + (border ? 0 : 1));
    }

    public @NotNull
    List<E> getEntryList() {
        return entryList;
    }

    public void setEntryList(@NotNull List<E> entryList) {
        this.entryList = entryList;
    }

    public boolean isBorder() {
        return border;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    public void copyValue(@Nullable FixedListWidget<E> copyValue) {
        if (copyValue != null) {
            this.selectedEntry = copyValue.selectedEntry;
            this.scrollAmount = copyValue.scrollAmount;
            this.selectedEntryIndex = copyValue.selectedEntryIndex;
        }
    }

    public float getMouseScrollAmount(double mouseAmount) {
        float am = (float) getIndividualHeight() / ((float) getIndividualHeight() * (float) Math.max((entryList.size() - entryShowCount), 1));

        float m = 1;
        if (OEClientUtils.isKeyInput(mc.field_1690.field_1832))
            m *= 3;
        if (OEClientUtils.isKeyInput(mc.field_1690.field_1867))
            m *= 10;

        return (float) mouseAmount * am * m;
    }

    public static interface PressEntry<E> {
        void onPressEntry(FixedListWidget<E> widget, E item);
    }
}
