package dev.felnull.otyacraftengine.fabric.data.provider;

import dev.felnull.otyacraftengine.data.provider.TagProviderWrapper;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import java.util.concurrent.CompletableFuture;


public class WrappedFabricTagProvider<T> extends FabricTagProvider<T> {
    private final TagProviderWrapper<T, TagProviderWrapper.TagProviderAccess<T, TagProviderWrapper.TagAppenderWrapper<T>>> tagProviderWrapper;

    public WrappedFabricTagProvider(FabricDataOutput output, class_5321<? extends class_2378<T>> registryKey, CompletableFuture<class_7225.class_7874> registriesFuture, TagProviderWrapper<T, TagProviderWrapper.TagProviderAccess<T, TagProviderWrapper.TagAppenderWrapper<T>>> tagProviderWrapper) {
        super(output, registryKey, registriesFuture);
        this.tagProviderWrapper = tagProviderWrapper;
    }

    @Override
    protected void method_10514(class_7225.class_7874 arg) {
        this.tagProviderWrapper.generateTag(new TagProviderAccessImpl());
    }

    private class TagProviderAccessImpl implements TagProviderWrapper.TagProviderAccess<T, TagProviderWrapper.TagAppenderWrapper<T>> {
        @Override
        public TagProviderWrapper.TagAppenderWrapper<T> tag(class_6862<T> tagKey) {
            return new TagAppenderWrapperImpl<>(WrappedFabricTagProvider.this.method_10512(tagKey));
        }
    }

    protected static class TagAppenderWrapperImpl<T> implements TagProviderWrapper.TagAppenderWrapper<T> {
        private final class_5124<T> appender;

        protected TagAppenderWrapperImpl(class_5124<T> appender) {
            this.appender = appender;
        }

        private TagAppenderWrapperImpl<T> of(class_5124<T> appender) {
            return new TagAppenderWrapperImpl<>(appender);
        }

        @Override
        public TagProviderWrapper.TagAppenderWrapper<T> addTag(class_6862<T> tagKey) {
            return of(appender.method_26792(tagKey));
        }

        @Override
        public TagProviderWrapper.TagAppenderWrapper<T> add(class_5321<T> resourceKey) {
            return of(appender.method_46835(resourceKey));
        }

        @Override
        public TagProviderWrapper.TagAppenderWrapper<T> add(class_5321<T>... resourceKeys) {
            return of(appender.method_40565(resourceKeys));
        }

        @Override
        public TagProviderWrapper.TagAppenderWrapper<T> addOptional(class_2960 resourceLocation) {
            return of(appender.method_35922(resourceLocation));
        }

        @Override
        public TagProviderWrapper.TagAppenderWrapper<T> addOptionalTag(class_2960 resourceLocation) {
            return of(appender.method_35923(resourceLocation));
        }

        @Override
        public TagProviderWrapper.TagAppenderWrapper<T> addVanillaTag(class_6862<T> tagKey) {
            return addOptionalTag(tagKey.comp_327());
        }
    }
}

