package dev.felnull.otyacraftengine.mixin;

import dev.felnull.otyacraftengine.item.IEquipmentItem;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public class LivingEntityMixin {
    @Inject(method = "getEquipmentSlotForItem", at = @At("HEAD"), cancellable = true)
    private static void getEquipmentSlotForItem(class_1799 itemStack, CallbackInfoReturnable<class_1304> cir) {
        if (itemStack.method_7909() instanceof IEquipmentItem equipmentItem) {
            var slot = equipmentItem.getEquipmentSlotType(itemStack);
            if (slot != null)
                cir.setReturnValue(slot);
        }
    }
}