package dev.felnull.otyacraftengine.block;

import com.google.common.collect.ImmutableList;
import dev.felnull.otyacraftengine.blockentity.IDroppedBlockEntity;
import dev.felnull.otyacraftengine.util.OEItemUtils;
import org.jetbrains.annotations.Nullable;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_47;

public abstract class OEBaseEntityBlock extends class_2237 {
    protected OEBaseEntityBlock(class_2251 properties) {
        super(properties);
    }

    @Override
    public void method_9567(class_1937 level, class_2338 blockPos, class_2680 blockState, @Nullable class_1309 livingEntity, class_1799 itemStack) {
        super.method_9567(level, blockPos, blockState, livingEntity, itemStack);
        if (itemStack.method_7938()) {
            if (level.method_8321(blockPos) instanceof class_2624 container) {
                container.method_17488(itemStack.method_7964());
            }
        }
    }

    @Override
    public void method_9536(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean bl) {
        if (!blockState.method_27852(blockState2.method_26204())) {
            var be = level.method_8321(blockPos);
            if (!level.method_8608() && level instanceof class_3218) {
                if (be instanceof IDroppedBlockEntity droppedBlockEntity) {
                    if (!droppedBlockEntity.isRetainDrop()) {
                        var drops = droppedBlockEntity.getDroppedItems();
                        class_2371<class_1799> items = class_2371.method_10211();
                        items.addAll(drops);
                        class_1264.method_17349(level, blockPos, items);
                    }
                } else if (be instanceof class_1263 container) {
                    class_1264.method_5451(level, blockPos, container);
                }
            }
        }
        super.method_9536(blockState, level, blockPos, blockState2, bl);
    }

    @Override
    public void method_9576(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1657 player) {
        var be = level.method_8321(blockPos);
        if (be instanceof IDroppedBlockEntity droppedBlockEntity && droppedBlockEntity.isRetainDrop()) {
            if (!level.field_9236 && player.method_7337()) {
                var dropItem = droppedBlockEntity.createRetainDropItem();
                if (!dropItem.method_7960()) {
                    if (be instanceof class_2624 named) {
                        if (named.method_16914())
                            dropItem.method_7977(named.method_5797());
                    }

                    var itemEntity = OEItemUtils.createItemEntity(dropItem, level, (double) blockPos.method_10263() + 0.5D, (double) blockPos.method_10264() + 0.5D, (double) blockPos.method_10260() + 0.5D);
                    level.method_8649(itemEntity);
                }
            }
        }
        super.method_9576(level, blockPos, blockState, player);
    }

    @Override
    public List<class_1799> method_9560(class_2680 blockState, class_47.class_48 builder) {
        var blockEntity = builder.method_305(class_181.field_1228);
        if (blockEntity instanceof IDroppedBlockEntity icbe && icbe.isRetainDrop())
            return ImmutableList.of(icbe.createRetainDropItem());

        return super.method_9560(blockState, builder);
    }
}
