package dev.felnull.otyacraftengine.client.entity;

import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import dev.felnull.fnjl.util.FNDataUtil;
import dev.felnull.otyacraftengine.util.OEPlayerUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1068;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4844;
import net.minecraft.class_640;

public class ClientPlayerInfoManager {
    private static final ClientPlayerInfoManager INSTANCE = new ClientPlayerInfoManager();
    private static final class_310 mc = class_310.method_1551();
    private final Map<String, GameProfile> PLAYER_PROFILES = new HashMap<>();
    private final Map<String, PlayerUUIDByNameResult> UUID_BY_NAME_ENTRY = new HashMap<>();
    private final Map<UUID, PlayerNameByUUIDResult> NAME_BY_UUID_ENTRY = new HashMap<>();
    private Function<String, class_2960> SKIN_TEXTURE_LOCATION_CACHE = createSkinTextureLocationCache();

    public static ClientPlayerInfoManager getInstance() {
        return INSTANCE;
    }

    public void clear() {
        synchronized (PLAYER_PROFILES) {
            PLAYER_PROFILES.clear();
        }
        SKIN_TEXTURE_LOCATION_CACHE = createSkinTextureLocationCache();
    }

    private Function<String, class_2960> createSkinTextureLocationCache() {
        return FNDataUtil.memoize(url -> {
            String hashStr = Hashing.sha1().hashUnencodedChars(FilenameUtils.getBaseName(url)).toString();
            return new class_2960("skins/" + hashStr);
        });
    }

    @NotNull
    public GameProfile getLackProfileTolerance(@NotNull String name) {
        synchronized (PLAYER_PROFILES) {
            if (PLAYER_PROFILES.containsKey(name))
                return PLAYER_PROFILES.get(name);
            var gp = new GameProfile(null, name);
            PLAYER_PROFILES.put(name, gp);
            class_2631.method_11335(gp, p -> {
                synchronized (PLAYER_PROFILES) {
                    PLAYER_PROFILES.put(name, p);
                }
            });
            return gp;
        }
    }

    @NotNull
    public Optional<UUID> getUUIDByName(@NotNull String name) {
        var cr = getUUIDByNameClient(name);
        if (cr != null)
            return Optional.of(cr);
        return OEPlayerUtils.getUUIDByName(name);
    }

    @NotNull
    public CompletableFuture<Optional<UUID>> getUUIDByNameAsync(@NotNull String name) {
        var cr = getUUIDByNameClient(name);
        if (cr != null)
            return CompletableFuture.completedFuture(Optional.of(cr));
        return OEPlayerUtils.getUUIDByNameAsync(name);
    }

    private UUID getUUIDByNameClient(String name) {
        if (mc.field_1724 != null) {
            if (mc.field_1724.method_7334().getName().equals(name))
                return mc.field_1724.method_7334().getId();

            var pl = mc.field_1724.field_3944.method_2874(name);
            if (pl != null && pl.method_2966() != null)
                return pl.method_2966().getId();
        }
        return null;
    }

    @NotNull
    public Optional<String> getNameByUUID(@NotNull UUID uuid) {
        var cr = getNameByUUIDClient(uuid);
        if (cr != null)
            return Optional.of(cr);
        return OEPlayerUtils.getNameByUUID(uuid);
    }

    @NotNull
    public CompletableFuture<Optional<String>> getNameByUUIDAsync(@NotNull UUID uuid) {
        var cr = getNameByUUIDClient(uuid);
        if (cr != null)
            return CompletableFuture.completedFuture(Optional.of(cr));
        return OEPlayerUtils.getNameByUUIDAsync(uuid);
    }

    private String getNameByUUIDClient(UUID uuid) {
        if (mc.field_1724 != null) {
            if (mc.field_1724.method_7334().getId().equals(uuid))
                return mc.field_1724.method_7334().getName();

            var pl = mc.field_1724.field_3944.method_2871(uuid);
            if (pl != null && pl.method_2966() != null)
                return pl.method_2966().getName();
        }
        return null;
    }

    @NotNull
    public PlayerUUIDByNameResult getUUIDByNameTolerance(@NotNull String name) {
        synchronized (UUID_BY_NAME_ENTRY) {
            var ret = UUID_BY_NAME_ENTRY.get(name);
            if (ret == null) {
                ret = new PlayerUUIDByNameResult(null, true);
                UUID_BY_NAME_ENTRY.put(name, ret);
                getUUIDByNameAsync(name).thenAcceptAsync(uuid -> {
                    synchronized (UUID_BY_NAME_ENTRY) {
                        UUID_BY_NAME_ENTRY.put(name, new PlayerUUIDByNameResult(uuid.orElse(null), false));
                    }
                });
            }
            return ret;
        }
    }

    @NotNull
    public PlayerNameByUUIDResult getNameByUUIDTolerance(@NotNull UUID uuid) {
        synchronized (NAME_BY_UUID_ENTRY) {
            var ret = NAME_BY_UUID_ENTRY.get(uuid);
            if (ret == null) {
                ret = new PlayerNameByUUIDResult(null, true);
                NAME_BY_UUID_ENTRY.put(uuid, ret);
                getNameByUUIDAsync(uuid).thenAcceptAsync(name -> {
                    synchronized (NAME_BY_UUID_ENTRY) {
                        NAME_BY_UUID_ENTRY.put(uuid, new PlayerNameByUUIDResult(name.orElse(null), false));
                    }
                });
            }
            return ret;
        }
    }

    @Nullable
    public class_2960 getPlayerTexture(@NotNull MinecraftProfileTexture.Type type, @NotNull String name) {
        if (mc.field_1724 != null) {
            var pl = mc.field_1724.field_3944.method_2874(name);
            if (pl != null)
                return getTexture(pl, type);
        }

        var gp = getLackProfileTolerance(name);
        var tex = mc.method_1582().method_4654(gp).get(type);
        if (tex != null) {
            var hr = SKIN_TEXTURE_LOCATION_CACHE.apply(tex.getUrl());
            var mt = class_1047.method_4540();
            var at = mc.method_1531().method_34590(hr, mt);
            if (at == mt)
                return mc.method_1582().method_4656(tex, type);
            return hr;
        }
        return type == MinecraftProfileTexture.Type.SKIN ? class_1068.method_4648(class_4844.method_43344(name)) : null;
    }

    @Nullable
    public class_2960 getPlayerTexture(@NotNull MinecraftProfileTexture.Type type, @NotNull UUID uuid) {
        if (mc.field_1724 != null) {
            var pl = mc.field_1724.field_3944.method_2871(uuid);
            if (pl != null)
                return getTexture(pl, type);
        }
        var name = getNameByUUIDTolerance(uuid).name();
        if (name != null)
            return getPlayerTexture(type, name);
        return type == MinecraftProfileTexture.Type.SKIN ? class_1068.method_4648(uuid) : null;
    }

    private class_2960 getTexture(class_640 playerInfo, MinecraftProfileTexture.Type type) {
        return switch (type) {
            case SKIN -> playerInfo.getSkinLocation();
            case CAPE -> playerInfo.getCapeLocation();
            case ELYTRA -> playerInfo.getElytraLocation();
        };
    }
}
