package dev.felnull.otyacraftengine.data.provider;

import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2405;
import net.minecraft.class_7225;
import net.minecraft.class_7784;

public abstract class DataProviderWrapper<T extends class_2405> implements DataProviderWrapperBase {
    private final CrossDataGeneratorAccess crossDataGeneratorAccess;
    public final class_7784 packOutput;

    public DataProviderWrapper(class_7784 packOutput, CrossDataGeneratorAccess crossDataGeneratorAccess) {
        this.packOutput = packOutput;
        this.crossDataGeneratorAccess = crossDataGeneratorAccess;
    }

    public CrossDataGeneratorAccess getCrossGeneratorAccess() {
        return crossDataGeneratorAccess;
    }

    public abstract T getProvider();

    public static interface Factory<T extends DataProviderWrapper<?>> {
        T create(class_7784 packOutput);
    }

    public static interface LookupFactory<T extends DataProviderWrapper<?>> {
        T create(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookup);
    }

    public static interface GeneratorAccessedFactory<T extends DataProviderWrapper<?>> {
        T create(class_7784 packOutput, CrossDataGeneratorAccess generatorAccess);
    }

    public static interface LookupGeneratorAccessedFactory<T extends DataProviderWrapper<?>> {
        T create(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookup, CrossDataGeneratorAccess generatorAccess);
    }
}
