package dev.felnull.otyacraftengine.data.provider;

import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import net.minecraft.class_1792;
import net.minecraft.class_2405;
import net.minecraft.class_7784;

public abstract class ItemModelProviderWrapper extends DataProviderWrapper<class_2405> {
    private final class_2405 itemModelProvider;

    public ItemModelProviderWrapper(class_7784 packOutput, CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(packOutput, crossDataGeneratorAccess);
        this.itemModelProvider = crossDataGeneratorAccess.createItemModelProvider(packOutput, this);
    }

    @Override
    public class_2405 getProvider() {
        return itemModelProvider;
    }

    public abstract void generateItemModels(ItemModelProviderAccess providerAccess);

    public static interface ItemModelProviderAccess {
        void basicFlatItem(class_1792 item);

        void builtinEntity(class_1792 item);
    }
}
