package dev.felnull.otyacraftengine.fabric.data.provider;

import dev.felnull.otyacraftengine.data.provider.IntrinsicHolderTagsProviderWrapper;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import java.util.concurrent.CompletableFuture;

public class WrappedFabricIntrinsicHolderTagsProvider<T> extends WrappedFabricTagProvider<T> {
    private final IntrinsicHolderTagsProviderWrapper<T, IntrinsicHolderTagsProviderWrapper.IntrinsicTagProviderAccess<T>> intrinsicHolderTagsProvider;

    public WrappedFabricIntrinsicHolderTagsProvider(FabricDataOutput output, class_5321<? extends class_2378<T>> registryKey, CompletableFuture<class_7225.class_7874> registriesFuture, IntrinsicHolderTagsProviderWrapper<T, IntrinsicHolderTagsProviderWrapper.IntrinsicTagProviderAccess<T>> intrinsicHolderTagsProvider) {
        super(output, registryKey, registriesFuture, null);
        this.intrinsicHolderTagsProvider = intrinsicHolderTagsProvider;
    }

    @Override
    protected void method_10514(class_7225.class_7874 arg) {
        this.intrinsicHolderTagsProvider.generateTag(new IntrinsicHolderTagProviderAccessImpl());
    }

    private class IntrinsicHolderTagProviderAccessImpl implements IntrinsicHolderTagsProviderWrapper.IntrinsicTagProviderAccess<T> {
        @Override
        public IntrinsicHolderTagsProviderWrapper.IntrinsicTagAppenderWrapper<T> tag(class_6862<T> tagKey) {
            return new IntrinsicHolderTagAppenderWrapperImpl<>(WrappedFabricIntrinsicHolderTagsProvider.this.method_10512(tagKey), intrinsicHolderTagsProvider);
        }
    }

    protected static class IntrinsicHolderTagAppenderWrapperImpl<T> extends WrappedFabricTagProvider.TagAppenderWrapperImpl<T> implements IntrinsicHolderTagsProviderWrapper.IntrinsicTagAppenderWrapper<T> {
        private final class_5124<T> tagAppender;
        private final IntrinsicHolderTagsProviderWrapper<T, ? extends IntrinsicHolderTagsProviderWrapper.IntrinsicTagProviderAccess<T>> tagProviderWrapper;

        protected IntrinsicHolderTagAppenderWrapperImpl(class_5124<T> appender, IntrinsicHolderTagsProviderWrapper<T, ? extends IntrinsicHolderTagsProviderWrapper.IntrinsicTagProviderAccess<T>> tagProviderWrapper) {
            super(appender);
            this.tagAppender = appender;
            this.tagProviderWrapper = tagProviderWrapper;
        }

        private IntrinsicHolderTagAppenderWrapperImpl<T> of(class_5124<T> appender) {
            return new IntrinsicHolderTagAppenderWrapperImpl<>(appender, tagProviderWrapper);
        }

        @Override
        public IntrinsicHolderTagsProviderWrapper.IntrinsicTagAppenderWrapper<T> add(T object) {
            return of(tagAppender.method_46835(tagProviderWrapper.getKeyExtractor().apply(object)));
        }

        @SafeVarargs
        @Override
        public final IntrinsicHolderTagsProviderWrapper.IntrinsicTagAppenderWrapper<T> add(T... objects) {
            IntrinsicHolderTagsProviderWrapper.IntrinsicTagAppenderWrapper<T> ret = null;

            for (T object : objects) {
                ret = this.add(object);
            }

            return ret == null ? of(tagAppender) : ret;
        }
    }
}
