package dev.felnull.otyacraftengine.client.shape;

import dev.architectury.registry.ReloadListenerRegistry;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.resources.PlatformResourceReloadListener;
import dev.felnull.otyacraftengine.shape.VoxelEdge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

public class ClientIVShapeManager extends PlatformResourceReloadListener<ClientIVShapeLoader> {
    private static final ClientIVShapeManager INSTANCE = new ClientIVShapeManager();
    private static final class_2960 VOXEL_SHAPE = new class_2960(OtyacraftEngine.MODID, "voxel_shape");
    private Map<class_2960, VoxelClientShape> voxelClientShapes;
    private Map<class_2960, VoxelClientShape> legacyVoxelClientShapes = new HashMap<>();

    public static ClientIVShapeManager getInstance() {
        return INSTANCE;
    }

    public void init() {
        ReloadListenerRegistry.register(class_3264.field_14188, this);
    }

    @Override
    protected ClientIVShapeLoader method_18789(@NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        return new ClientIVShapeLoader(resourceManager, profilerFiller);
    }

    @Override
    protected void apply(@NotNull ClientIVShapeLoader loader, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        voxelClientShapes = loader.getVoxelClientShapes();
    }

    @Nullable
    public VoxelClientShape getVoxelClientShape(@Nullable class_2960 location) {
        var ret = voxelClientShapes.get(location);
        if (ret != null)
            return ret;
        return legacyVoxelClientShapes.get(location);
    }

    public void addLegacyShapes(class_2960 location, Set<VoxelEdge> edges) {
        legacyVoxelClientShapes.put(location, new VoxelClientShape(null, null, edges));
    }

    @Override
    public @NotNull class_2960 getId() {
        return VOXEL_SHAPE;
    }
}
