package dev.felnull.otyacraftengine.data.provider;

import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.model.FileModel;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2405;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2960;
import net.minecraft.class_4917;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_7784;

public abstract class BlockStateAndModelProviderWrapper extends DataProviderWrapper<class_2405> {
    public static final class_2960 OE_BASE_BLOCK_ENTITY_MODEL = new class_2960(OtyacraftEngine.MODID, "base/block_entity");
    public static final class_2960 OE_BASE_BLOCK_ENTITY_APPEARANCE_MODEL = new class_2960(OtyacraftEngine.MODID, "base/block_entity_appearance");
    private final class_2405 blockStateAndModelProvider;

    public BlockStateAndModelProviderWrapper(class_7784 packOutput, CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(packOutput, crossDataGeneratorAccess);
        this.blockStateAndModelProvider = crossDataGeneratorAccess.createBlockStateAndModelProvider(packOutput, this);
    }

    @Override
    public class_2405 getProvider() {
        return blockStateAndModelProvider;
    }

    public abstract void generateStatesAndModels(BlockStateAndModelProviderAccess providerAccess);

    /**
     * BlockModelGenerators$createHorizontalFacingDispatchの移植
     *
     * @return PropertyDispatch
     */
    public class_4926 createHorizontalFacingDispatch() {
        return class_4926.method_25783(class_2741.field_12481)
                .method_25793(class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22891))
                .method_25793(class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22892))
                .method_25793(class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22893))
                .method_25793(class_2350.field_11043, class_4935.method_25824());
    }

    /**
     * BlockModelGenerators$createBooleanModelDispatchの移植
     *
     * @return PropertyDispatch
     */
    public class_4926 createBooleanModelDispatch(class_2746 booleanProperty, class_2960 trueLoc, class_2960 falseLoc) {
        return class_4926.method_25783(booleanProperty)
                .method_25793(true, class_4935.method_25824().method_25828(class_4936.field_22887, trueLoc))
                .method_25793(false, class_4935.method_25824().method_25828(class_4936.field_22887, falseLoc));
    }

    public static interface BlockStateAndModelProviderAccess {
        void genSimpleCubeBlockStateModelAndItemModel(class_2248 block);

        FileModel genCubeAllBlockModel(String fileName, class_2960 texture);

        FileModel genCubeBlockModel(String fileName, class_2960 down, class_2960 up, class_2960 north, class_2960 south, class_2960 east, class_2960 west);

        FileModel getExistingModel(class_2960 location);

        FileModel genParticleOnlyModel(class_2248 block, class_2960 particleLocation);

        void genSimpleBlockState(class_2248 block, FileModel model);

        /**
         * Fabricの場合、アイテムモデル未登録時にステートを登録していれば勝手に自動登録される
         *
         * @param block ブロック
         * @param model モデル
         */
        void genSimpleBlockItemModel(class_2248 block, FileModel model);

        void genHorizontalBlockState(class_2248 block, FileModel model);

        void genBuiltinEntityBlockItemModel(class_2248 block);

        void genParentedBlockItemModel(class_2248 block, class_2960 parentLocation);

        void addBlockStateGenerator(class_4917 blockStateGenerator);
    }
}
