package dev.felnull.otyacraftengine.data.provider;

import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.model.MutableFileModel;
import net.minecraft.class_1792;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7784;

public abstract class ItemModelProviderWrapper extends DataProviderWrapper<class_2405> {
    private final class_2405 itemModelProvider;

    public ItemModelProviderWrapper(class_7784 packOutput, CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(packOutput, crossDataGeneratorAccess);
        this.itemModelProvider = crossDataGeneratorAccess.createItemModelProvider(packOutput, this);
    }

    @Override
    public class_2405 getProvider() {
        return itemModelProvider;
    }

    public abstract void generateItemModels(ItemModelProviderAccess providerAccess);

    public static interface ItemModelProviderAccess {
        MutableFileModel basicFlatItem(class_1792 item);

        MutableFileModel basicFlatItem(class_2960 itemLocation);

        MutableFileModel handheldFlatItem(class_1792 item);

        MutableFileModel handheldFlatItem(class_2960 itemLocation);

        MutableFileModel builtinEntity(class_1792 item);

        MutableFileModel builtinEntity(class_2960 itemLocation);
    }
}
