package dev.felnull.otyacraftengine.fabric.data.provider;

import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.model.FileModel;
import dev.felnull.otyacraftengine.data.provider.BlockStateAndModelProviderWrapper;
import dev.felnull.otyacraftengine.fabric.data.model.FileModelImpl;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class WrappedFabricBlockModelProvider extends FabricModelProvider {
    private final CrossDataGeneratorAccess crossDataGeneratorAccess;
    private final BlockStateAndModelProviderWrapper blockStateAndModelProviderWrapper;

    public WrappedFabricBlockModelProvider(FabricDataOutput output, CrossDataGeneratorAccess crossDataGeneratorAccess, BlockStateAndModelProviderWrapper blockStateAndModelProviderWrapper) {
        super(output);
        this.crossDataGeneratorAccess = crossDataGeneratorAccess;
        this.blockStateAndModelProviderWrapper = blockStateAndModelProviderWrapper;
    }

    @Override
    public String getName() {
        return "Model Definitions (Block)";
    }

    @Override
    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        this.blockStateAndModelProviderWrapper.generateStatesAndModels(new BlockStateAndModelProviderAccessImpl(blockStateModelGenerator));
    }

    @Override
    public void generateItemModels(class_4915 itemModelGenerator) {

    }

    private class BlockStateAndModelProviderAccessImpl implements BlockStateAndModelProviderWrapper.BlockStateAndModelProviderAccess {
        private final class_4910 blockModelGenerators;

        private BlockStateAndModelProviderAccessImpl(class_4910 blockModelGenerators) {
            this.blockModelGenerators = blockModelGenerators;
        }

        @Override
        public void genSimpleCubeBlockStateModelAndItemModel(class_2248 block) {
            this.blockModelGenerators.method_25641(block);
        }

        private FileModel of(class_2960 location) {
            return new FileModelImpl(location);
        }

        @Override
        public FileModel genCubeAllBlockModel(String fileName, class_2960 texture) {
            return of(class_4943.field_22972.method_25852(new class_2960(crossDataGeneratorAccess.getMod().getModId(), "block/" + fileName), class_4944.method_25875(texture), blockModelGenerators.field_22831));
        }

        @Override
        public FileModel genCubeBlockModel(String fileName, class_2960 down, class_2960 up, class_2960 north, class_2960 south, class_2960 east, class_2960 west) {
            class_4944 mapping = new class_4944();
            mapping.method_25868(class_4945.field_23024, down);
            mapping.method_25868(class_4945.field_23023, up);
            mapping.method_25868(class_4945.field_23019, north);
            mapping.method_25868(class_4945.field_23020, south);
            mapping.method_25868(class_4945.field_23021, east);
            mapping.method_25868(class_4945.field_23022, west);
            mapping.method_25868(class_4945.field_23012, north);

            return of(class_4943.field_22942.method_25852(new class_2960(crossDataGeneratorAccess.getMod().getModId(), "block/" + fileName), mapping, blockModelGenerators.field_22831));
        }

        @Override
        public FileModel getExistingModel(class_2960 location) {
            return of(location);
        }

        @Override
        public FileModel genParticleOnlyModel(class_2248 block, class_2960 particleLocation) {
            class_4944 textureMapping = class_4944.method_25891(particleLocation);
            return of(class_4943.field_22908.method_25846(block, textureMapping, blockModelGenerators.field_22831));
        }

        @Override
        public void genSimpleBlockState(class_2248 block, FileModel model) {
            this.blockModelGenerators.field_22830.accept(class_4910.method_25644(block, model.getLocation()));
        }

        @Override
        public void genSimpleBlockItemModel(class_2248 block, FileModel model) {
            this.blockModelGenerators.method_25623(block, model.getLocation());
        }

        @Override
        public void genHorizontalBlockState(class_2248 block, FileModel model) {
            this.blockModelGenerators.field_22830.accept(class_4925.method_25770(block, class_4935.method_25824().method_25828(class_4936.field_22887, model.getLocation()))
                    .method_25775(class_4910.method_25599()));
        }

        @Override
        public void genBuiltinEntityBlockItemModel(class_2248 block) {
            WrappedFabricItemModelProvider.BUILTIN_ENTITY.method_25852(class_4941.method_25840(block.method_8389()), new class_4944(), this.blockModelGenerators.field_22831);
        }

        @Override
        public void genParentedBlockItemModel(class_2248 block, class_2960 parentLocation) {
            this.blockModelGenerators.method_25623(block, parentLocation);
        }

        @Override
        public void addBlockStateGenerator(class_4917 blockStateGenerator) {
            this.blockModelGenerators.field_22830.accept(blockStateGenerator);
        }
    }
}
