package dev.felnull.otyacraftengine.fabric.data.provider;

import dev.felnull.otyacraftengine.data.model.MutableFileModel;
import dev.felnull.otyacraftengine.data.provider.ItemModelProviderWrapper;
import dev.felnull.otyacraftengine.fabric.data.model.JsonModelInjector;
import dev.felnull.otyacraftengine.fabric.data.model.MutableFileModelImpl;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import java.util.Optional;


public class WrappedFabricItemModelProvider extends FabricModelProvider {
    public static final class_4942 BUILTIN_ENTITY = new class_4942(Optional.of(new class_2960("minecraft", "builtin/entity")), Optional.empty());
    private final ItemModelProviderWrapper itemModelProviderWrapper;

    public WrappedFabricItemModelProvider(FabricDataOutput output, ItemModelProviderWrapper itemModelProviderWrapper) {
        super(output);
        this.itemModelProviderWrapper = itemModelProviderWrapper;
    }

    @Override
    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
    }

    @Override
    public void generateItemModels(class_4915 itemModelGenerator) {
        this.itemModelProviderWrapper.generateItemModels(new ItemModelProviderAccessImpl(itemModelGenerator));
    }

    @Override
    public String getName() {
        return "Model Definitions (Item)";
    }

    private static class ItemModelProviderAccessImpl implements ItemModelProviderWrapper.ItemModelProviderAccess {
        private final class_4915 itemModelGenerators;

        private ItemModelProviderAccessImpl(class_4915 itemModelGenerator) {
            this.itemModelGenerators = itemModelGenerator;
        }

        @Override
        public MutableFileModel basicFlatItem(class_1792 item) {
            return createLayer0Model(class_4943.field_22938, item);
        }

        @Override
        public MutableFileModel basicFlatItem(class_2960 itemLocation) {
            return createLayer0Model(class_4943.field_22938, itemLocation);
        }

        @Override
        public MutableFileModel handheldFlatItem(class_1792 item) {
            return createLayer0Model(class_4943.field_22939, item);
        }

        @Override
        public MutableFileModel handheldFlatItem(class_2960 itemLocation) {
            return createLayer0Model(class_4943.field_22939, itemLocation);
        }

        @Override
        public MutableFileModel builtinEntity(class_1792 item) {
            return createModel(BUILTIN_ENTITY, new class_4944(), item);
        }

        @Override
        public MutableFileModel builtinEntity(class_2960 itemLocation) {
            return createModel(BUILTIN_ENTITY, new class_4944(), itemLocation);
        }

        private MutableFileModelImpl createLayer0Model(class_4942 modelTemplate, class_2960 itemLocation) {
            var ji = new JsonModelInjector(this.itemModelGenerators.field_22844);
            var loc = decorateItemModelLocation(itemLocation);
            modelTemplate.method_25852(loc, class_4944.method_25895(loc), ji.injectedModelOutput());
            return new MutableFileModelImpl(loc, ji);
        }

        private MutableFileModelImpl createLayer0Model(class_4942 modelTemplate, class_1792 item) {
            return createModel(modelTemplate, class_4944.method_25871(item), item);
        }

        private MutableFileModelImpl createModel(class_4942 modelTemplate, class_4944 textureMapping, class_2960 itemLocation) {
            var ji = new JsonModelInjector(this.itemModelGenerators.field_22844);
            var loc = decorateItemModelLocation(itemLocation);
            modelTemplate.method_25852(loc, textureMapping, ji.injectedModelOutput());
            return new MutableFileModelImpl(loc, ji);
        }

        private MutableFileModelImpl createModel(class_4942 modelTemplate, class_4944 textureMapping, class_1792 item) {
            var ji = new JsonModelInjector(this.itemModelGenerators.field_22844);
            var loc = class_4941.method_25840(item);
            modelTemplate.method_25852(loc, textureMapping, ji.injectedModelOutput());
            return new MutableFileModelImpl(loc, ji);
        }
    }

    private static class_2960 decorateItemModelLocation(class_2960 location) {
        return new class_2960(location.method_12836(), "item/" + location.method_12832());
    }
}

