package dev.felnull.otyacraftengine.fabric.data.provider;

import dev.felnull.otyacraftengine.data.provider.RecipeProviderWrapper;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2096;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_6862;
import java.util.function.Consumer;

public class WrappedFabricRecipeProvider extends FabricRecipeProvider {
    private final RecipeProviderWrapper recipeProviderWrapper;

    public WrappedFabricRecipeProvider(FabricDataOutput output, RecipeProviderWrapper recipeProviderWrapper) {
        super(output);
        this.recipeProviderWrapper = recipeProviderWrapper;
    }

    @Override
    public void buildRecipes(Consumer<class_2444> exporter) {
        recipeProviderWrapper.generateRecipe(exporter, new RecipeProviderAccessImpl());
    }

    private static class RecipeProviderAccessImpl implements RecipeProviderWrapper.RecipeProviderAccess {
        @Override
        public class_2066.class_2068 has(class_2096.class_2100 ints, class_1935 itemLike) {
            return class_2446.method_35914(ints, itemLike);
        }

        @Override
        public class_2066.class_2068 has(class_1935 itemLike) {
            return class_2446.method_10426(itemLike);
        }

        @Override
        public class_2066.class_2068 has(class_6862<class_1792> tagKey) {
            return class_2446.method_10420(tagKey);
        }

        @Override
        public String getHasName(class_1935 itemLike) {
            return class_2446.method_32807(itemLike);
        }

        @Override
        public String getItemName(class_1935 itemLike) {
            return class_2446.method_33716(itemLike);
        }
    }
}
