package dev.felnull.otyacraftengine.client.event;

import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import dev.architectury.event.EventResult;
import net.minecraft.class_4184;
import net.minecraft.class_5636;
import net.minecraft.class_6854;
import net.minecraft.class_758;

/**
 * カメラ関係のイベント
 */
public interface ClientCameraEvent {
    Event<RenderFog> RENDER_FOG = EventFactory.createEventResult();
    Event<ComputeFogColor> COMPUTE_FOG_COLOR = EventFactory.createEventResult();

    interface RenderFog {
        EventResult onRenderFog(class_4184 camera, class_758.class_4596 fogMode, class_5636 fogType, float startDistance, float endDistance, class_6854 fogShape, double delta, RenderFogSetter setter);
    }

    interface ComputeFogColor {
        EventResult onComputeFogColor(class_4184 camera, float red, float green, float blue, double delta, FogColorSetter fogColorSetter);
    }

    interface RenderFogSetter {
        void setStartDistance(float startDistance);

        void setEndDistance(float endDistance);

        void setFogShape(class_6854 fogShape);
    }

    interface FogColorSetter {
        void setRed(float red);

        void setGreen(float green);

        void setBlue(float blue);
    }
}
