package dev.felnull.otyacraftengine.data.model;

import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4917;
import org.jetbrains.annotations.NotNull;

public interface BlockStateAndModelProviderAccess {
    void simpleCubeBlockStateModelAndItemModel(@NotNull class_2248 block);

    @NotNull
    FileModel cubeAllBlockModel(@NotNull String fileName, @NotNull class_2960 texture);

    @NotNull
    FileModel cubeAllBlockModel(@NotNull class_2248 block, @NotNull class_2960 texture);

    @NotNull
    FileModel cubeBlockModel(@NotNull String fileName, @NotNull class_2960 down, @NotNull class_2960 up, @NotNull class_2960 north, @NotNull class_2960 south, @NotNull class_2960 east, @NotNull class_2960 west);

    @NotNull
    FileModel cubeBlockModel(@NotNull class_2248 block, @NotNull class_2960 down, @NotNull class_2960 up, @NotNull class_2960 north, @NotNull class_2960 south, @NotNull class_2960 east, @NotNull class_2960 west);

    @NotNull
    FileModel cubeBottomTopBlockModel(@NotNull String fileName, @NotNull class_2960 bottom, @NotNull class_2960 side, @NotNull class_2960 top);

    @NotNull
    FileModel cubeBottomTopBlockModel(@NotNull class_2248 block, @NotNull class_2960 bottom, @NotNull class_2960 side, @NotNull class_2960 top);

    @NotNull
    MutableFileModel parentedBlockModel(@NotNull class_2248 block, @NotNull class_2960 parentLocation);

    @NotNull
    FileModel existingModel(@NotNull class_2960 location);

    @NotNull
    FileModel particleOnlyModel(@NotNull class_2248 block, @NotNull class_2960 particleLocation);

    void simpleBlockState(@NotNull class_2248 block, @NotNull FileModel model);

    /**
     * Fabricの場合、ステートを登録していればアイテムモデル未登録でも勝手に自動登録される。
     * でもForgeでは自動登録されないのでこれを利用してください。
     *
     * @param block ブロック
     * @param model モデル
     */
    void simpleBlockItemModel(@NotNull class_2248 block, @NotNull FileModel model);

    void horizontalBlockState(@NotNull class_2248 block, @NotNull FileModel model);

    default void builtinEntityBlockItemModel(@NotNull class_2248 block) {
        parentedBlockItemModel(block, new class_2960("builtin/entity"));
    }

    void parentedBlockItemModel(@NotNull class_2248 block, @NotNull class_2960 parentLocation);

    void addBlockStateGenerator(@NotNull class_4917 blockStateGenerator);

    ItemModelProviderAccess itemModelProviderAccess();
}
