package dev.felnull.otyacraftengine.data.model;

import net.minecraft.class_1792;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public interface ItemModelProviderAccess {
    @NotNull
    MutableFileModel basicFlatItem(@NotNull class_1792 item);

    @NotNull
    MutableFileModel basicFlatItem(@NotNull class_2960 itemLocation);

    @NotNull
    MutableFileModel basicFlatItem(@NotNull class_1792 item, class_2960 texture);

    @NotNull
    MutableFileModel basicFlatItem(@NotNull class_2960 itemLocation, class_2960 texture);

    @NotNull
    MutableFileModel handheldFlatItem(@NotNull class_1792 item);

    @NotNull
    MutableFileModel handheldFlatItem(@NotNull class_2960 itemLocation);

    @NotNull
    default MutableFileModel builtinEntityItem(@NotNull class_1792 item) {
        return parentedItem(item, new class_2960("builtin/entity"));
    }

    @NotNull
    default MutableFileModel builtinEntityItem(@NotNull class_2960 itemLocation) {
        return parentedItem(itemLocation, new class_2960("builtin/entity"));
    }

    @NotNull
    MutableFileModel parentedItem(@NotNull class_1792 item, @NotNull class_2960 parentLocation);

    @NotNull
    MutableFileModel parentedItem(@NotNull class_2960 itemLocation, @NotNull class_2960 parentLocation);
}
