package dev.felnull.otyacraftengine.data.provider;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.provider.model.ModelProcessSubProviderWrapper;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import record;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class ModelProcessProviderWrapper extends InputBaseProviderWrapper {
    private static final Gson GSON = new Gson();
    private final List<ModelProcessSubProviderWrapper> subProviderWrappers;

    public ModelProcessProviderWrapper(class_7784 packOutput, CrossDataGeneratorAccess crossDataGeneratorAccess, List<ModelProcessSubProviderWrapper> subProviderWrappers) {
        super(packOutput, class_7784.class_7490.field_39368, "models", crossDataGeneratorAccess);
        this.subProviderWrappers = subProviderWrappers;
    }

    @Override
    public String getName() {
        return "Model Process";
    }

    @Override
    protected @Nullable CompletableFuture<?> runTask(class_7403 cachedOutput, Path inputRoot, Path target) {
        return CompletableFuture.supplyAsync(() -> {
            var locEx = toResourceLocationAndExtension(inputRoot, target);
            try (Reader reader = new FileReader(target.toFile()); Reader bufReadr = new BufferedReader(reader)) {
                return new ModelData(locEx.getLeft(), GSON.fromJson(bufReadr, JsonObject.class));
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, class_156.method_18349()).thenComposeAsync(r -> runConvert(cachedOutput, r), class_156.method_18349()).handleAsync((models, throwable) -> models, class_156.method_18349()).thenComposeAsync(models -> {
            if (models != null) {
                List<CompletableFuture<?>> saves = new ArrayList<>();
                for (ModelData model : models) {
                    saves.add(DataProvider.saveStable(cachedOutput, model.model(), pathProvider.json(model.location())));
                }
                return CompletableFuture.allOf(saves.toArray(CompletableFuture[]::new));
            }
            return CompletableFuture.completedFuture(null);
        }, class_156.method_18349());
    }

    @NotNull
    protected CompletableFuture<List<ModelData>> runConvert(class_7403 cachedOutput, ModelData base) {
        CompletableFuture<List<ModelData>> cf = CompletableFuture.completedFuture(ImmutableList.of(base));
        for (ModelProcessSubProviderWrapper subProviderWrapper : subProviderWrappers) {
            cf = cf.thenApplyAsync(r -> subProviderWrapper.process(cachedOutput, r), class_156.method_18349());
        }
        return cf;
    }

    public static record ModelData(class_2960 location, JsonObject model) {
        public String getName() {
            var sp = location.getPath().split("/");
            return sp[sp.length - 1];
        }
    }
}
