package dev.felnull.otyacraftengine.data.provider;

import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.tag.ManualTagHolder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2474;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7784;

public abstract class TagProviderWrapper<T, A extends TagProviderWrapper.TagProviderAccess<T, ? extends TagProviderWrapper.TagAppenderWrapper<T>>> extends DataProviderWrapper<class_2474<T>> {
    private final CompletableFuture<class_7225.class_7874> lookup;

    public TagProviderWrapper(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookup, CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(packOutput, crossDataGeneratorAccess);
        this.lookup = lookup;
    }

    public CompletableFuture<class_7225.class_7874> getLookup() {
        return lookup;
    }

    public abstract void generateTag(A providerAccess);

    public static interface TagProviderAccess<T, W extends TagAppenderWrapper<T>> {
        W tag(class_6862<T> tagKey);
    }

    public static interface TagAppenderWrapper<T> {
        TagAppenderWrapper<T> addTag(class_6862<T> tagKey);

        TagAppenderWrapper<T> add(class_5321<T> resourceKey);

        TagAppenderWrapper<T> add(class_5321<T>... resourceKeys);

        TagAppenderWrapper<T> addOptional(class_2960 resourceLocation);

        TagAppenderWrapper<T> addOptionalTag(class_2960 resourceLocation);

        default TagAppenderWrapper<T> addTags(List<class_6862<T>> tagKeys) {
            TagAppenderWrapper<T> appenderWrapper = this;

            for (class_6862<T> tagKey : tagKeys)
                appenderWrapper = appenderWrapper.addTag(tagKey);

            return appenderWrapper;
        }

        default TagAppenderWrapper<T> addTagHolders(List<ManualTagHolder<T>> tagHolders) {
            TagAppenderWrapper<T> appenderWrapper = this;

            for (ManualTagHolder<T> tagHolder : tagHolders)
                appenderWrapper = appenderWrapper.addTagHolder(tagHolder);

            return appenderWrapper;
        }

        default TagAppenderWrapper<T> addOptionalTag(class_2960... resourceLocations) {
            TagAppenderWrapper<T> appenderWrapper = this;

            for (class_2960 resourceLocation : resourceLocations)
                appenderWrapper = appenderWrapper.addOptionalTag(resourceLocation);

            return appenderWrapper;
        }

        default TagAppenderWrapper<T> addTagHolder(ManualTagHolder<T> tagHolder) {
           /* var tp = getTagProvider();
            if (tp != null)
                tagHolder.registering(tp);*/
            return addTag(tagHolder.getKey());
        }

        default TagAppenderWrapper<T> addVanillaTag(class_6862<T> tagKey) {
            return addTag(tagKey);
        }

    }
}
