package dev.felnull.otyacraftengine.data.provider.model;

import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.provider.DataProviderWrapperBase;
import dev.felnull.otyacraftengine.data.provider.ModelProcessProviderWrapper;
import java.util.List;
import net.minecraft.class_7403;

public abstract class ModelProcessSubProviderWrapper implements DataProviderWrapperBase {
    protected final CrossDataGeneratorAccess crossDataGeneratorAccess;

    public ModelProcessSubProviderWrapper(CrossDataGeneratorAccess crossDataGeneratorAccess) {
        this.crossDataGeneratorAccess = crossDataGeneratorAccess;
    }

    @Override
    public CrossDataGeneratorAccess getCrossGeneratorAccess() {
        return crossDataGeneratorAccess;
    }

    public List<ModelProcessProviderWrapper.ModelData> process(class_7403 cachedOutput, List<ModelProcessProviderWrapper.ModelData> modelData) {
        return modelData.stream().flatMap(r -> process(cachedOutput, r).stream()).toList();
    }

    public abstract List<ModelProcessProviderWrapper.ModelData> process(class_7403 cachedOutput, ModelProcessProviderWrapper.ModelData modelData);
}
