package dev.felnull.otyacraftengine.fabric.data.model;

import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.model.BlockStateAndModelProviderAccess;
import dev.felnull.otyacraftengine.data.model.FileModel;
import dev.felnull.otyacraftengine.data.model.ItemModelProviderAccess;
import dev.felnull.otyacraftengine.data.model.MutableFileModel;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4940;
import net.minecraft.class_4941;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.data.models.model.*;
import org.jetbrains.annotations.NotNull;

public class BlockStateAndModelProviderAccessImpl implements BlockStateAndModelProviderAccess {
    private final CrossDataGeneratorAccess crossDataGeneratorAccess;
    private final class_4910 blockModelGenerators;
    private final ItemModelProviderAccess itemModelProviderAccess;

    public BlockStateAndModelProviderAccessImpl(CrossDataGeneratorAccess crossDataGeneratorAccess, class_4910 blockModelGenerators) {
        this.crossDataGeneratorAccess = crossDataGeneratorAccess;
        this.blockModelGenerators = blockModelGenerators;
        this.itemModelProviderAccess = new ItemModelProviderAccessImpl(blockModelGenerators.field_22831);
    }

    @Override
    public void simpleCubeBlockStateModelAndItemModel(@NotNull class_2248 block) {
        this.blockModelGenerators.method_25641(block);
    }

    private FileModel of(class_2960 location) {
        return new FileModelImpl(location);
    }

    @Override
    public @NotNull FileModel cubeAllBlockModel(@NotNull String fileName, @NotNull class_2960 texture) {
        return of(class_4943.field_22972.method_25852(blockLoc(fileName), class_4944.method_25875(texture), blockModelGenerators.field_22831));
    }

    @Override
    public @NotNull FileModel cubeAllBlockModel(@NotNull class_2248 block, @NotNull class_2960 texture) {
        return of(class_4943.field_22972.method_25846(block, class_4944.method_25875(texture), blockModelGenerators.field_22831));
    }

    @Override
    public @NotNull FileModel cubeBlockModel(@NotNull String fileName, @NotNull class_2960 down, @NotNull class_2960 up, @NotNull class_2960 north, @NotNull class_2960 south, @NotNull class_2960 east, @NotNull class_2960 west) {
        class_4944 mapping = new class_4944();
        mapping.method_25868(class_4945.field_23024, down);
        mapping.method_25868(class_4945.field_23023, up);
        mapping.method_25868(class_4945.field_23019, north);
        mapping.method_25868(class_4945.field_23020, south);
        mapping.method_25868(class_4945.field_23021, east);
        mapping.method_25868(class_4945.field_23022, west);
        mapping.method_25868(class_4945.field_23012, north);

        return of(class_4943.field_22942.method_25852(blockLoc(fileName), mapping, blockModelGenerators.field_22831));
    }

    @Override
    public @NotNull FileModel cubeBlockModel(@NotNull class_2248 block, @NotNull class_2960 down, @NotNull class_2960 up, @NotNull class_2960 north, @NotNull class_2960 south, @NotNull class_2960 east, @NotNull class_2960 west) {
        class_4944 mapping = new class_4944();
        mapping.method_25868(class_4945.field_23024, down);
        mapping.method_25868(class_4945.field_23023, up);
        mapping.method_25868(class_4945.field_23019, north);
        mapping.method_25868(class_4945.field_23020, south);
        mapping.method_25868(class_4945.field_23021, east);
        mapping.method_25868(class_4945.field_23022, west);
        mapping.method_25868(class_4945.field_23012, north);

        return of(class_4943.field_22942.method_25846(block, mapping, blockModelGenerators.field_22831));
    }

    @Override
    public @NotNull FileModel cubeBottomTopBlockModel(@NotNull String fileName, @NotNull class_2960 bottom, @NotNull class_2960 side, @NotNull class_2960 top) {
        class_4944 mapping = new class_4944();
        mapping.method_25868(class_4945.field_23015, top);
        mapping.method_25868(class_4945.field_23014, bottom);
        mapping.method_25868(class_4945.field_23018, side);

        return of(class_4943.field_22977.method_25852(blockLoc(fileName), mapping, blockModelGenerators.field_22831));
    }

    @Override
    public @NotNull FileModel cubeBottomTopBlockModel(@NotNull class_2248 block, @NotNull class_2960 bottom, @NotNull class_2960 side, @NotNull class_2960 top) {
        class_4944 mapping = new class_4944();
        mapping.method_25868(class_4945.field_23015, top);
        mapping.method_25868(class_4945.field_23014, bottom);
        mapping.method_25868(class_4945.field_23018, side);

        return of(class_4943.field_22977.method_25846(block, mapping, blockModelGenerators.field_22831));
    }

    private class_2960 blockLoc(String name) {
        return new class_2960(crossDataGeneratorAccess.getMod().getModId(), "block/" + name);
    }

    @Override
    public @NotNull MutableFileModel parentedBlockModel(@NotNull class_2248 block, @NotNull class_2960 parentLocation) {
        var ji = new JsonModelInjector(this.blockModelGenerators.field_22831);
        var loc = class_4941.method_25842(block);
        ji.injectedModelOutput().accept(loc, new class_4940(parentLocation));
        return new MutableFileModelImpl(loc, ji);
    }

    @Override
    public @NotNull FileModel existingModel(@NotNull class_2960 location) {
        return of(location);
    }

    @Override
    public @NotNull FileModel particleOnlyModel(@NotNull class_2248 block, @NotNull class_2960 particleLocation) {
        class_4944 textureMapping = class_4944.method_25891(particleLocation);
        return of(class_4943.field_22908.method_25846(block, textureMapping, blockModelGenerators.field_22831));
    }

    @Override
    public void simpleBlockState(@NotNull class_2248 block, @NotNull FileModel model) {
        this.blockModelGenerators.field_22830.accept(class_4910.method_25644(block, model.getLocation()));
    }

    @Override
    public void simpleBlockItemModel(@NotNull class_2248 block, @NotNull FileModel model) {
        this.blockModelGenerators.method_25623(block, model.getLocation());
    }

    @Override
    public void horizontalBlockState(@NotNull class_2248 block, @NotNull FileModel model) {
        this.blockModelGenerators.field_22830.accept(class_4925.method_25770(block, class_4935.method_25824().method_25828(class_4936.field_22887, model.getLocation()))
                .method_25775(class_4910.method_25599()));
    }

    @Override
    public void parentedBlockItemModel(@NotNull class_2248 block, @NotNull class_2960 parentLocation) {
        this.blockModelGenerators.method_25623(block, parentLocation);
    }

    @Override
    public void addBlockStateGenerator(@NotNull class_4917 blockStateGenerator) {
        this.blockModelGenerators.field_22830.accept(blockStateGenerator);
    }

    @Override
    public ItemModelProviderAccess itemModelProviderAccess() {
        return this.itemModelProviderAccess;
    }
}
