package dev.felnull.otyacraftengine.fabric.mixin.client;

import dev.felnull.otyacraftengine.client.event.ClientCameraEvent;
import dev.felnull.otyacraftengine.client.event.OEClientEventHooks;
import net.minecraft.class_1297;
import net.minecraft.class_4184;
import net.minecraft.class_5636;
import net.minecraft.class_638;
import net.minecraft.class_6854;
import net.minecraft.class_758;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(class_758.class)
public class FogRendererMixin {
    @Shadow
    private static float fogRed;

    @Shadow
    private static float fogGreen;

    @Shadow
    private static float fogBlue;

    @Inject(method = "setupColor", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/systems/RenderSystem;clearColor(FFFF)V", remap = false, ordinal = 1))
    private static void setupColor(class_4184 camera, float f, class_638 clientLevel, int i, float g, CallbackInfo ci) {
        OEClientEventHooks.onComputeFogColor(camera, fogRed, fogGreen, fogBlue, f, new ClientCameraEvent.FogColorSetter() {
            @Override
            public void setRed(float red) {
                fogRed = red;
            }

            @Override
            public void setGreen(float green) {
                fogGreen = green;
            }

            @Override
            public void setBlue(float blue) {
                fogBlue = blue;
            }
        });
    }

    @Inject(method = "setupFog", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/systems/RenderSystem;setShaderFogStart(F)V", remap = false, ordinal = 0, shift = At.Shift.BY, by = -1), locals = LocalCapture.CAPTURE_FAILHARD)
    private static void setupFog(class_4184 camera, class_758.class_4596 fogMode, float f, boolean bl, float g, CallbackInfo ci, class_5636 fogType, class_1297 entity, class_758.class_7285 fogData) {
        float[] distance = {fogData.field_38340, fogData.field_38341};
        class_6854[] shapes = {fogData.field_38342};

        if (!OEClientEventHooks.onRenderFog(camera, fogMode, fogType, fogData.field_38340, fogData.field_38341, fogData.field_38342, g, new ClientCameraEvent.RenderFogSetter() {
            @Override
            public void setStartDistance(float startDistance) {
                distance[0] = startDistance;
            }

            @Override
            public void setEndDistance(float endDistance) {
                distance[1] = endDistance;
            }

            @Override
            public void setFogShape(class_6854 fogShape) {
                shapes[0] = fogShape;
            }
        })) {
            ((FogRendererFogDataAccessor) fogData).setStart(distance[0]);
            ((FogRendererFogDataAccessor) fogData).setEnd(distance[1]);
            ((FogRendererFogDataAccessor) fogData).setShape(shapes[0]);
        }
    }

}
