package dev.felnull.otyacraftengine.util;

import dev.architectury.registry.menu.MenuRegistry;
import dev.felnull.otyacraftengine.item.location.PlayerItemLocation;
import dev.felnull.otyacraftengine.item.location.PlayerItemLocations;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;

public final class OEMenuUtil {
    public static void openItemMenu(class_3222 player, class_3908 provider, PlayerItemLocation location, class_1799 stack, int inventorySize) {
        if (player.method_7325()) return;
        MenuRegistry.openExtendedMenu(player, provider, n -> {
            n.writeBoolean(true);
            n.method_10794(PlayerItemLocations.saveToTag(location));
            n.method_10793(stack);
            n.writeInt(inventorySize);
        });
    }

    public static void openBlockMenu(class_3222 player, class_3908 provider, class_2338 pos, int inventorySize) {
        if (player.method_7325()) return;
        MenuRegistry.openExtendedMenu(player, provider, n -> {
            n.writeBoolean(false);
            n.method_10807(pos);
            n.writeInt(inventorySize);
        });
    }

    public static <T extends class_1703> class_3917<T> createMenuType(OEBlockMenuFactory<T> factory) {
        return MenuRegistry.ofExtended((id, inventory, buf) -> {
            buf.readBoolean();
            return factory.create(id, inventory, buf.method_10811(), new class_1277(buf.readInt()));
        });
    }

    public static <T extends class_1703> class_3917<T> createMenuType(OEItemMenuFactory<T> factory) {
        return MenuRegistry.ofExtended((id, inventory, buf) -> {
            buf.readBoolean();
            var tag = buf.method_10798();
            PlayerItemLocation location = PlayerItemLocations.loadFromTag(tag);
            return factory.create(id, inventory, buf.method_10819(), location, new class_1277(buf.readInt()));
        });
    }

    public static <T extends class_1703> class_3917<T> createMenuType(OEBlockMenuFactory<T> factoryBlock, OEItemMenuFactory<T> factoryItem) {
        return MenuRegistry.ofExtended((id, inventory, buf) -> {
            if (buf.readBoolean()) {
                PlayerItemLocation location = PlayerItemLocations.loadFromTag(buf.method_10798());
                return factoryItem.create(id, inventory, buf.method_10819(), location, new class_1277(buf.readInt()));
            } else {
                return factoryBlock.create(id, inventory, buf.method_10811(), new class_1277(buf.readInt()));
            }
        });
    }

    public interface OEBlockMenuFactory<T extends class_1703> {
        T create(int id, class_1661 inventory, class_2338 pos, class_1263 container);
    }

    public interface OEItemMenuFactory<T extends class_1703> {
        T create(int id, class_1661 inventory, class_1799 stack, PlayerItemLocation location, class_1263 container);
    }
}
