/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.data.provider;

import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.provider.BasicProviderWrapper;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNStringUtil;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public abstract class InputBaseProviderWrapper
extends BasicProviderWrapper {
    protected final class_7784.class_7489 pathProvider;
    protected final class_7784.class_7490 target;
    protected final String modId;
    protected final String kind;

    public InputBaseProviderWrapper(class_7784 packOutput, class_7784.class_7490 target, String kind, CrossDataGeneratorAccess crossDataGeneratorAccess) {
        this(packOutput, target, crossDataGeneratorAccess.getMod().getModId(), kind, crossDataGeneratorAccess);
    }

    public InputBaseProviderWrapper(class_7784 packOutput, class_7784.class_7490 target, String modId, String kind, CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(packOutput, crossDataGeneratorAccess);
        this.pathProvider = packOutput.method_45973(target, kind);
        this.target = target;
        this.modId = modId;
        this.kind = kind;
    }

    @Override
    public CompletableFuture<?> run(class_7403 cachedOutput) {
        ArrayList tasks = new ArrayList();
        Collection<Path> inPaths = this.getCrossGeneratorAccess().getResourceInputFolders();
        for (Path inPath : inPaths) {
            Path targetPath = inPath.resolve(InputBaseProviderWrapper.targetByName(this.target)).resolve(this.modId).resolve(this.kind);
            if (!Files.exists(targetPath, new LinkOption[0])) continue;
            try {
                Stream<Path> walk = Files.walk(targetPath, new FileVisitOption[0]);
                try {
                    walk.forEach(path -> {
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            return;
                        }
                        if (!this.isTarget(inPath, (Path)path)) {
                            return;
                        }
                        CompletableFuture<?> task = this.runTask(cachedOutput, inPath, (Path)path);
                        if (task != null) {
                            tasks.add(task);
                        }
                    });
                }
                finally {
                    if (walk == null) continue;
                    walk.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return CompletableFuture.allOf((CompletableFuture[])tasks.toArray(CompletableFuture[]::new));
    }

    protected abstract boolean isTarget(Path var1, Path var2);

    @Nullable
    protected abstract CompletableFuture<?> runTask(class_7403 var1, Path var2, Path var3);

    private static String targetByName(class_7784.class_7490 target) {
        switch (target) {
            case field_39367: {
                return "data";
            }
            case field_39368: {
                return "assets";
            }
            case field_39369: {
                return "reports";
            }
        }
        throw new RuntimeException("Unexpected target.");
    }

    protected Pair<class_2960, String> toResourceLocationAndExtension(Path inputRoot, Path target) {
        Path relativePath = inputRoot.relativize(target);
        StringBuilder sb = new StringBuilder();
        String ex = "";
        for (int i = 0; i < relativePath.getNameCount() - 3; ++i) {
            String p = relativePath.getName(i + 3).toFile().getName();
            if (i == relativePath.getNameCount() - 4) {
                sb.append(FNStringUtil.removeExtension(p));
                ex = FNStringUtil.getExtension(p);
                continue;
            }
            sb.append(p).append("/");
        }
        return Pair.of((Object)new class_2960(relativePath.getName(1).toFile().getName(), sb.toString()), (Object)ex);
    }
}

