package dev.felnull.otyacraftengine.client.gui.components;


import dev.felnull.otyacraftengine.client.gui.TextureSpecify;
import dev.felnull.otyacraftengine.client.gui.components.base.OEBaseImageWidget;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class SwitchButton extends OEBaseImageWidget {
    @Nullable
    private final Consumer<SwitchButton> onPress;
    private boolean showLabel;
    private boolean enable;

    public SwitchButton(int x, int y, @NotNull class_2561 message, @Nullable Consumer<SwitchButton> onPress, boolean showLabel) {
        this(x, y, message, onPress, showLabel, TextureSpecify.createRelative(WIDGETS, 40, 0, 40, 34));
    }

    public SwitchButton(int x, int y, @NotNull class_2561 message, @Nullable Consumer<SwitchButton> onPress, boolean showLabel, @NotNull TextureSpecify texture) {
        super(x, y, 20, 10, "switchButton", message, texture);
        this.onPress = onPress;
        this.showLabel = showLabel;
    }

    @Override
    public void method_25359(@NotNull class_4587 poseStack, int i, int j, float f) {
        OERenderUtils.drawTexture(texture.getTextureLocation(), poseStack, method_46426(), method_46427(), texture.getU0() + (this.method_25367() ? 20 : 0), texture.getV0() + (this.enable ? 10 : 0), 20, 10, texture.getTextureWidth(), texture.getTextureHeight());
        OERenderUtils.drawTexture(texture.getTextureLocation(), poseStack, method_46426() + (this.enable ? (field_22758 - 8) : 0), method_46427() - 2, texture.getU0() + (this.method_25367() ? 8 : 0), texture.getV0() + 20, 8, 14, texture.getTextureWidth(), texture.getTextureHeight());
        this.method_25353(poseStack, mc, i, j);
        if (this.showLabel)
            drawTextBase(poseStack, this.method_25369(), this.method_46426() + 24, this.method_46427() + (this.field_22759 - 8) / 2, 14737632 | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
    }

    @Override
    public void onPress() {
        this.enable = !this.enable;
        if (onPress != null)
            this.onPress.accept(this);
    }

    public boolean isShowLabel() {
        return showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public boolean isEnable() {
        return enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }
}
