package dev.felnull.otyacraftengine.fabric.client.handler;

import LayerEntry;
import dev.felnull.otyacraftengine.client.callpoint.ClientCallPointManager;
import dev.felnull.otyacraftengine.client.callpoint.LayerRegister;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_3887;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_922;
import record;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class ClientHandlerFabric {
    private static List<LayerEntry<? extends class_1309>> LAYERS;

    public static void init() {
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register(ClientHandlerFabric::registerRenderers);
    }

    private static void registerRenderers(class_1299<? extends class_1309> entityType, class_922<?, ?> entityRenderer, LivingEntityFeatureRendererRegistrationCallback.RegistrationHelper registrationHelper, class_5617.class_5618 context) {
        if (LAYERS == null) {
            LAYERS = new ArrayList<>();

            ClientCallPointManager.getInstance().call().onLayerRegistry(new LayerRegister() {
                @Override
                public <T extends class_1309> void addLayer(class_1299<T> entityType, Function<class_922<T, ? extends class_583<T>>, class_3887<T, ? extends class_583<T>>> layer) {
                    LayerEntry<T> entry = getLayers(entityType);
                    if (entry == null) {
                        entry = new LayerEntry<T>(entityType, new ArrayList<>());
                        LAYERS.add(entry);
                    }
                    entry.layer().add(livingEntityRenderer -> layer.apply((LivingEntityRenderer<T, ? extends EntityModel<T>>) livingEntityRenderer));
                }
            });
        }

        var ls = getLayers(entityType);
        if (ls != null) {
            for (Function<class_922<?, ?>, ? extends class_3887<?, ? extends class_583<?>>> livingEntityRendererFunction : ls.layer()) {
                class_3887 layer = livingEntityRendererFunction.apply(entityRenderer);
                registrationHelper.register(layer);
            }
        }
    }

    private static <T extends class_1309> LayerEntry<T> getLayers(class_1299<T> entityType) {
        var ls = LAYERS.stream().filter(n -> n.entityType() == entityType).findFirst();
        return (LayerEntry<T>) ls.orElse(null);
    }

    private static record LayerEntry<T extends LivingEntity>(class_1299<T> entityType,
                                                             List<Function<LivingEntityRenderer<?, ?>, RenderLayer<T, ? extends EntityModel<T>>>> layer) {
    }
}
