package dev.felnull.otyacraftengine.fabric.data.model;

import com.google.gson.JsonElement;
import dev.felnull.otyacraftengine.data.model.FileTexture;
import dev.felnull.otyacraftengine.data.model.ItemModelProviderAccess;
import dev.felnull.otyacraftengine.data.model.MutableFileModel;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_4940;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.data.models.model.*;
import org.jetbrains.annotations.NotNull;

import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class ItemModelProviderAccessImpl implements ItemModelProviderAccess {
    private final BiConsumer<class_2960, Supplier<JsonElement>> output;

    public ItemModelProviderAccessImpl(BiConsumer<class_2960, Supplier<JsonElement>> output) {
        this.output = output;
    }


    @Override
    public @NotNull MutableFileModel basicFlatItem(@NotNull class_1792 item) {
        return createLayer0Model(class_4943.field_22938, item);
    }

    @Override
    public @NotNull MutableFileModel basicFlatItem(@NotNull FileTexture itemTexture) {
        return createLayer0Model(class_4943.field_22938, itemTexture.getLocation());
    }

    @Override
    public @NotNull MutableFileModel basicFlatItem(@NotNull class_1792 item, @NotNull FileTexture itemTexture) {
        return createModel(class_4943.field_22938, class_4944.method_25895(itemTexture.getLocation()), item);
    }

    @Override
    public @NotNull MutableFileModel basicFlatItem(@NotNull class_2960 itemLocation, @NotNull FileTexture itemTexture) {
        return createModel(class_4943.field_22938, class_4944.method_25895(itemTexture.getLocation()), itemLocation);
    }

    @Override
    public @NotNull MutableFileModel handheldFlatItem(@NotNull class_1792 item) {
        return createLayer0Model(class_4943.field_22939, item);
    }

    @Override
    public @NotNull MutableFileModel handheldFlatItem(@NotNull FileTexture itemTexture) {
        return createLayer0Model(class_4943.field_22939, itemTexture.getLocation());
    }

    @Override
    public @NotNull MutableFileModel parentedItem(@NotNull class_1792 item, @NotNull class_2960 parentLocation) {
        var ji = new JsonModelInjector(this.output);
        var loc = class_4941.method_25840(item);
        ji.injectedModelOutput().accept(loc, new class_4940(parentLocation));
        return new MutableFileModelImpl(loc, ji);
    }

    @Override
    public @NotNull MutableFileModel parentedItem(@NotNull class_2960 itemLocation, @NotNull class_2960 parentLocation) {
        var ji = new JsonModelInjector(this.output);
        var loc = decorateItemModelLocation(itemLocation);
        ji.injectedModelOutput().accept(loc, new class_4940(parentLocation));
        return new MutableFileModelImpl(loc, ji);
    }

    private MutableFileModelImpl createLayer0Model(class_4942 modelTemplate, class_2960 itemLocation) {
        return createModel(modelTemplate, class_4944.method_25895(decorateItemModelLocation(itemLocation)), itemLocation);
    }

    private MutableFileModelImpl createLayer0Model(class_4942 modelTemplate, class_1792 item) {
        return createModel(modelTemplate, class_4944.method_25871(item), item);
    }

    private MutableFileModelImpl createModel(class_4942 modelTemplate, class_4944 textureMapping, class_2960 itemLocation) {
        var ji = new JsonModelInjector(this.output);
        var loc = decorateItemModelLocation(itemLocation);
        modelTemplate.method_25852(loc, textureMapping, ji.injectedModelOutput());
        return new MutableFileModelImpl(loc, ji);
    }

    private MutableFileModelImpl createModel(class_4942 modelTemplate, class_4944 textureMapping, class_1792 item) {
        var ji = new JsonModelInjector(this.output);
        var loc = class_4941.method_25840(item);
        modelTemplate.method_25852(loc, textureMapping, ji.injectedModelOutput());
        return new MutableFileModelImpl(loc, ji);
    }

    private static class_2960 decorateItemModelLocation(class_2960 location) {
        return new class_2960(location.method_12836(), "item/" + location.method_12832());
    }
}