package dev.felnull.otyacraftengine.fabric.data.provider;

import dev.felnull.otyacraftengine.data.provider.BlockLootTableProviderWrapper;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import java.util.function.BiConsumer;

public class WrappedFabricBlockLootTableProvider extends FabricBlockLootTableProvider {
    private final BlockLootTableProviderWrapper blockLootTableProviderWrapper;

    public WrappedFabricBlockLootTableProvider(FabricDataOutput dataOutput, BlockLootTableProviderWrapper blockLootTableProviderWrapper) {
        super(dataOutput);
        this.blockLootTableProviderWrapper = blockLootTableProviderWrapper;
    }

    @Override
    public void generate() {
        blockLootTableProviderWrapper.generateBlockLootTables(this, new BlockLootTableProviderAccessImpl());
    }

    private class BlockLootTableProviderAccessImpl implements BlockLootTableProviderWrapper.BlockLootTableProviderAccess {
        @Override
        public void excludeFromStrictValidation(class_2248 block) {
            WrappedFabricBlockLootTableProvider.this.excludeFromStrictValidation(block);
        }

        @Override
        public void dropSelf(class_2248 block) {
            WrappedFabricBlockLootTableProvider.this.dropSelf(block);
        }

        @Override
        public void dropOther(class_2248 block, class_1935 itemLike) {
            WrappedFabricBlockLootTableProvider.this.dropOther(block, itemLike);
        }

        @Override
        public void dropWhenSilkTouch(class_2248 block) {
            WrappedFabricBlockLootTableProvider.this.dropWhenSilkTouch(block);
        }

        @Override
        public void otherWhenSilkTouch(class_2248 block, class_2248 drop) {
            WrappedFabricBlockLootTableProvider.this.otherWhenSilkTouch(block, drop);
        }

        @Override
        public void add(class_2248 block, class_52.class_53 builder) {
            WrappedFabricBlockLootTableProvider.this.add(block, builder);
        }
    }

    @Override
    public void accept(BiConsumer<class_2960, class_52.class_53> resourceLocationBuilderBiConsumer) {
        generate(resourceLocationBuilderBiConsumer);
    }
}
