package dev.felnull.otyacraftengine.fabric.mixin.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.felnull.otyacraftengine.fabric.data.provider.WrappedRegistriesDatapackGenerator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_5475;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7655;

@Mixin(class_5475.class)
public abstract class RegistriesDatapackGeneratorMixin {
    @Shadow
    @Final
    private CompletableFuture<class_7225.class_7874> registries;

    @Shadow
    protected abstract <T> Optional<CompletableFuture<?>> dumpRegistryCap(class_7403 cachedOutput, class_7225.class_7874 provider, DynamicOps<JsonElement> dynamicOps, class_7655.class_7657<T> registryData);

    @Inject(method = "run", at = @At("HEAD"), cancellable = true)
    private void run(class_7403 cachedOutput, CallbackInfoReturnable<CompletableFuture<?>> cir) {
        if ((Object) this instanceof WrappedRegistriesDatapackGenerator) {
            cir.setReturnValue(this.registries.thenCompose((provider) -> {
                DynamicOps<JsonElement> dynamicOps = class_6903.method_46632(JsonOps.INSTANCE, provider);
                return CompletableFuture.allOf(WrappedRegistriesDatapackGenerator.getUnitedDataPackRegistries().flatMap((registryData) -> {
                    return this.dumpRegistryCap(cachedOutput, provider, dynamicOps, registryData).stream();
                }).toArray(CompletableFuture[]::new));
            }));
        }
    }
}
