package dev.felnull.otyacraftengine.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.felnull.otyacraftengine.client.gui.TextureRegion;
import dev.felnull.otyacraftengine.client.gui.components.base.OEBasedButton;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;

public class SwitchButton extends OEBasedButton {
    private final boolean showLabel;
    private boolean enable;

    public SwitchButton(int x, int y, @NotNull class_2561 message, boolean showLabel) {
        this(x, y, message, TextureRegion.relative(OE_WIDGETS, 40, 0, 40, 34), showLabel);
    }

    public SwitchButton(int x, int y, @NotNull class_2561 message, @NotNull TextureRegion texture, boolean showLabel) {
        super(x, y, 20, 10, message, "switchButton", texture);
        this.showLabel = showLabel;
    }

    @Override
    public void method_25306() {
        this.enable = !this.enable;
    }

    @Override
    public void method_48579(class_4587 poseStack, int mx, int my, float delta) {
        class_310 minecraft = class_310.method_1551();
        RenderSystem.setShaderTexture(0, getTexture().location());
        RenderSystem.enableDepthTest();
        class_327 font = minecraft.field_1772;
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, this.field_22765);
        OERenderUtils.blitFloat(poseStack, method_46426(), method_46427(), getTexture().u0() + (this.method_25367() ? 20 : 0), getTexture().v0() + (this.enable ? 10 : 0), 20, 10, getTexture().width(), getTexture().height());
        OERenderUtils.blitFloat(poseStack, method_46426() + (this.enable ? (field_22758 - 8) : 0), method_46427() - 2, getTexture().u0() + (this.method_25367() ? 8 : 0), getTexture().v0() + 20, 8, 14, getTexture().width(), getTexture().height());

        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
        if (this.showLabel)
            method_27535(poseStack, font, this.method_25369(), this.method_46426() + 24, this.method_46427() + (this.field_22759 - 8) / 2, 14737632 | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
    }

    public boolean isEnable() {
        return enable;
    }
}
