package dev.felnull.otyacraftengine.client.gui.components.base;

import dev.felnull.otyacraftengine.client.gui.TextureRegion;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_5250;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OEBasedWidget extends class_339 implements OEBaseComponent {
    @Nullable
    private final String widgetTypeName;
    @NotNull
    private TextureRegion texture;

    public OEBasedWidget(int x, int y, int width, int height, @NotNull class_2561 message, @NotNull TextureRegion texture) {
        this(x, y, width, height, null, message, texture);
    }

    public OEBasedWidget(int x, int y, int width, int height, @Nullable String widgetTypeName, @NotNull class_2561 message, @NotNull TextureRegion texture) {
        super(x, y, width, height, message);
        this.widgetTypeName = widgetTypeName;
        this.texture = texture;
    }

    @Override
    protected void method_47399(class_6382 narrationElementOutput) {
        this.method_37021(narrationElementOutput);
    }

    @Override
    protected void method_37021(class_6382 narrationElementOutput) {
        if (this.widgetTypeName == null) {
            super.method_37021(narrationElementOutput);
            return;
        }

        narrationElementOutput.method_37034(class_6381.field_33788, this.method_25360());
        if (this.field_22763) {
            if (this.method_25370()) {
                narrationElementOutput.method_37034(class_6381.field_33791, class_2561.method_43471("narration." + widgetTypeName + ".usage.focused"));
            } else {
                narrationElementOutput.method_37034(class_6381.field_33791, class_2561.method_43471("narration." + widgetTypeName + ".usage.hovered"));
            }
        }
    }

    @Override
    protected class_5250 method_25360() {
        if (widgetTypeName == null)
            return super.method_25360();
        return class_2561.method_43469("gui.narrate." + widgetTypeName, method_25369());
    }

    @Override
    public void method_25348(double d, double e) {
        this.onFocusedClick();
    }

    @Override
    public boolean method_25404(int i, int j, int k) {
        if (this.field_22763 && this.field_22764) {
            if (i != 257 && i != 32 && i != 335) return false;
            this.method_25354(mc.method_1483());
            this.onFocusedClick();
            return true;
        }
        return false;
    }

    @Override
    public @Nullable String getWidgetTypeName() {
        return widgetTypeName;
    }

    public abstract void onFocusedClick();

    @NotNull
    @Override
    public TextureRegion getTexture() {
        return texture;
    }

    @Override
    public void setTexture(@NotNull TextureRegion texture) {
        this.texture = texture;
    }
}
