package dev.felnull.otyacraftengine.data;

import dev.architectury.platform.Mod;
import dev.felnull.otyacraftengine.data.provider.*;
import org.jetbrains.annotations.NotNull;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2446;
import net.minecraft.class_2474;
import net.minecraft.class_3611;
import net.minecraft.class_4158;
import net.minecraft.class_5475;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import net.minecraft.class_7877;
import net.minecraft.class_8110;

public interface CrossDataGeneratorAccess {
    @NotNull class_2403 getVanillaGenerator();

    <T extends class_2405> T addProvider(@NotNull class_2405.class_7857<T> factory);

    <T extends class_2405> T addProvider(@NotNull BiFunction<class_7784, CompletableFuture<class_7225.class_7874>, T> dataProviderSupplier);

    default <T extends DataProviderWrapper<?>> T addProviderWrapper(@NotNull DataProviderWrapper.GeneratorAccessedFactory<T> factory) {
        return addProviderWrapper(packOutput -> factory.create(packOutput, CrossDataGeneratorAccess.this));
    }

    default <T extends DataProviderWrapper<?>> T addProviderWrapper(@NotNull DataProviderWrapper.Factory<T> factory) {
        AtomicReference<T> providerWrapper = new AtomicReference<>();

        addProvider(packOutput -> {
            providerWrapper.set(factory.create(packOutput));
            return providerWrapper.get().getProvider();
        });

        return providerWrapper.get();
    }

    default <T extends DataProviderWrapper<?>> T addProviderWrapper(@NotNull DataProviderWrapper.LookupGeneratorAccessedFactory<T> factory) {
        return addProviderWrapper((DataProviderWrapper.LookupFactory<T>) (packOutput, lookup) -> factory.create(packOutput, lookup, CrossDataGeneratorAccess.this));
    }

    default <T extends DataProviderWrapper<?>> T addProviderWrapper(@NotNull DataProviderWrapper.LookupFactory<T> factory) {
        AtomicReference<T> providerWrapper = new AtomicReference<>();

        addProvider((packOutput, lookup) -> {
            providerWrapper.set(factory.create(packOutput, lookup));
            return providerWrapper.get().getProvider();
        });

        return providerWrapper.get();
    }

    Mod getMod();

    class_2446 createRecipeProvider(class_7784 packOutput, RecipeProviderWrapper recipeProviderWrapper);

    class_2474<class_1792> createItemTagProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookup, ItemTagProviderWrapper itemTagProviderWrapper, @NotNull BlockTagProviderWrapper blockTagProviderWrapper);

    class_2474<class_3611> createFluidTagProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookup, FluidTagProviderWrapper fluidTagProviderWrapper);

    class_2474<class_2248> createBlockTagProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookup, BlockTagProviderWrapper blockTagProviderWrapper);

    class_2474<class_4158> createPoiTypeTagProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookup, PoiTypeTagProviderWrapper poiTypeTagProviderWrapper);

    class_2474<class_8110> createDamageTypeTagProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookup, DamageTypeTagsProviderWrapper damageTypeTagsProviderWrapper);

    class_2405 createBasicProvider(BasicProviderWrapper basicProviderWrapper);

    class_2405 createBlockLootTableProvider(class_7784 packOutput, BlockLootTableProviderWrapper blockLootTableProviderWrapper);

    class_2405 createAdvancementProvider(class_7784 packOutput, AdvancementProviderWrapper advancementProviderWrapper, List<AdvancementSubProviderWrapper> subProviderWrappers);

    class_2405 createItemModelProvider(class_7784 packOutput, ItemModelProviderWrapper itemModelProviderWrapper);

    class_2405 createBlockStateAndModelProvider(class_7784 packOutput, BlockStateAndModelProviderWrapper blockStateAndModelProviderWrapper);

    class_5475 createRegistriesDatapackGenerator(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookup, class_7877 registrySetBuilder);

    Collection<Path> getResourceInputFolders();

    void addResourceInputFolders(Path path);
}
