package dev.felnull.otyacraftengine.data.model;

import com.google.common.base.Preconditions;
import dev.felnull.otyacraftengine.data.model.impl.FileTextureImpl;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

/**
 * テクスチャファイルの指定
 */
public interface FileTexture {
    /**
     * リソースロケーションを指定する
     *
     * @param textureLocation テクスチャのリソースロケーション
     * @return テクスチャ指定
     */
    @NotNull
    static FileTexture of(@NotNull class_2960 textureLocation) {
        Preconditions.checkNotNull(textureLocation, "TextureLocation is Null");

        return new FileTextureImpl(textureLocation, true);
    }

    /**
     * リソースロケーションを指定する<br>
     * Forgeの存在の検証をスキップする
     *
     * @param textureLocation テクスチャのリソースロケーション
     * @return テクスチャ指定
     */
    @NotNull
    static FileTexture ofUncheck(@NotNull class_2960 textureLocation) {
        Preconditions.checkNotNull(textureLocation, "TextureLocation is Null");

        return new FileTextureImpl(textureLocation, false);
    }

    /**
     * リソースロケーションを指定する
     *
     * @param textureLocation テクスチャのリソースロケーション
     * @param existingCheck   存在の検証
     * @return テクスチャ指定
     */
    @NotNull
    static FileTexture of(@NotNull class_2960 textureLocation, boolean existingCheck) {
        Preconditions.checkNotNull(textureLocation, "TextureLocation is Null");

        return new FileTextureImpl(textureLocation, existingCheck);
    }

    /**
     * 指定されたテクスチャのリソースロケーション
     *
     * @return リソースロケーション
     */
    @NotNull
    class_2960 getLocation();

    /**
     * Forgeの存在の検証を実行するかどうか
     *
     * @return 実行するかどうか
     */
    boolean isExistingCheck();
}
