package dev.felnull.otyacraftengine.data.model;

import net.minecraft.class_1792;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

/**
 * それぞれのプラットフォームで同じ動作をするアイテムモデル生成
 */
public interface ItemModelProviderAccess {
    /**
     * 通常の板状アイテムを生成
     *
     * @param item アイテム
     * @return モデル
     */
    @NotNull
    MutableFileModel basicFlatItem(@NotNull class_1792 item);

    /**
     * 通常の板状アイテムを生成
     *
     * @param itemLocation ロケーション
     * @return モデル
     */
    @NotNull
    default MutableFileModel basicFlatItem(@NotNull class_2960 itemLocation) {
        return basicFlatItem(FileTexture.of(itemLocation));
    }

    /**
     * 通常の板状アイテムを生成
     *
     * @param itemTexture ファイルテクスチャ
     * @return モデル
     */
    @NotNull
    MutableFileModel basicFlatItem(@NotNull FileTexture itemTexture);

    /**
     * 通常の板状アイテムを生成
     *
     * @param item            アイテム
     * @param textureLocation ロケーション
     * @return モデル
     */
    @NotNull
    default MutableFileModel basicFlatItem(@NotNull class_1792 item, @NotNull class_2960 textureLocation) {
        return basicFlatItem(item, FileTexture.of(textureLocation));
    }

    /**
     * 通常の板状アイテムを生成
     *
     * @param item        アイテム
     * @param itemTexture ファイルテクスチャ
     * @return モデル
     */
    @NotNull
    MutableFileModel basicFlatItem(@NotNull class_1792 item, @NotNull FileTexture itemTexture);

    /**
     * 通常の板状アイテムを生成
     *
     * @param itemLocation    アイテムロケーション
     * @param textureLocation テクスチャロケーション
     * @return モデル
     */
    @NotNull
    default MutableFileModel basicFlatItem(@NotNull class_2960 itemLocation, @NotNull class_2960 textureLocation) {
        return basicFlatItem(itemLocation, FileTexture.of(textureLocation));
    }

    /**
     * 通常の板状アイテムを生成
     *
     * @param itemLocation テクスチャロケーション
     * @param itemTexture  ファイルテクスチャ
     * @return モデル
     */
    @NotNull
    MutableFileModel basicFlatItem(@NotNull class_2960 itemLocation, @NotNull FileTexture itemTexture);

    /**
     * 剣や棒の持ち方をする板状アイテムを生成
     *
     * @param item アイテム
     * @return モデル
     */
    @NotNull
    MutableFileModel handheldFlatItem(@NotNull class_1792 item);

    /**
     * 剣や棒の持ち方をする板状アイテムを生成
     *
     * @param itemLocation アイテムロケーション
     * @return モデル
     */
    @NotNull
    default MutableFileModel handheldFlatItem(@NotNull class_2960 itemLocation) {
        return handheldFlatItem(FileTexture.of(itemLocation));
    }

    /**
     * 剣や棒の持ち方をする板状アイテムを生成
     *
     * @param itemTexture ファイルテクスチャ
     * @return モデル
     */
    @NotNull
    MutableFileModel handheldFlatItem(@NotNull FileTexture itemTexture);

    /**
     * ビルトインエンティティアイテム
     *
     * @param item アイテム
     * @return モデル
     */
    @NotNull
    default MutableFileModel builtinEntityItem(@NotNull class_1792 item) {
        return parentedItem(item, new class_2960("builtin/entity"));
    }

    /**
     * ビルトインエンティティアイテム
     *
     * @param itemLocation アイテムロケーション
     * @return モデル
     */
    @NotNull
    default MutableFileModel builtinEntityItem(@NotNull class_2960 itemLocation) {
        return parentedItem(itemLocation, new class_2960("builtin/entity"));
    }

    /**
     * 親モデルを継承するアイテム
     *
     * @param item           アイテム
     * @param parentLocation 親モデルのロケーション
     * @return モデル
     */
    @NotNull
    MutableFileModel parentedItem(@NotNull class_1792 item, @NotNull class_2960 parentLocation);

    /**
     * 親モデルを継承するアイテム
     *
     * @param itemLocation   アイテムロケーション
     * @param parentLocation 親モデルのロケーション
     * @return モデル
     */
    @NotNull
    MutableFileModel parentedItem(@NotNull class_2960 itemLocation, @NotNull class_2960 parentLocation);
}
