package dev.felnull.otyacraftengine.data.provider;

import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import org.jetbrains.annotations.NotNull;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2474;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7784;

public abstract class ItemTagProviderWrapper extends IntrinsicHolderTagsProviderWrapper<class_1792, ItemTagProviderWrapper.ItemTagProviderAccess> {
    private final class_2474<class_1792> itemTagsProvider;

    public ItemTagProviderWrapper(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookup, CrossDataGeneratorAccess crossDataGeneratorAccess, @NotNull BlockTagProviderWrapper blockTagProviderWrapper) {
        super(packOutput, lookup, crossDataGeneratorAccess);
        this.itemTagsProvider = crossDataGeneratorAccess.createItemTagProvider(packOutput, lookup, this, blockTagProviderWrapper);
    }

    @Override
    public Function<class_1792, class_5321<class_1792>> getKeyExtractor() {
        return (item) -> item.method_40131().method_40237();
    }

    @Override
    public class_2474<class_1792> getProvider() {
        return this.itemTagsProvider;
    }

    public static interface ItemTagProviderAccess extends IntrinsicTagProviderAccess<class_1792> {
        void copy(class_6862<class_2248> blockTag, class_6862<class_1792> itemTag);
    }
}
