package dev.felnull.otyacraftengine.fabric.data;

import com.google.common.collect.ImmutableList;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.provider.*;
import dev.felnull.otyacraftengine.fabric.data.provider.*;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2446;
import net.minecraft.class_2474;
import net.minecraft.class_3611;
import net.minecraft.class_4158;
import net.minecraft.class_5475;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import net.minecraft.class_7877;
import net.minecraft.class_8110;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;

@ApiStatus.Internal
public class CrossDataGeneratorAccessImpl implements CrossDataGeneratorAccess {
    private final List<Path> resourceInputFolders = new ArrayList<>();
    private final FabricDataGenerator fabricDataGenerator;
    private final FabricDataGenerator.Pack pack;

    protected CrossDataGeneratorAccessImpl(FabricDataGenerator fabricDataGenerator) {
        this.fabricDataGenerator = fabricDataGenerator;
        this.pack = fabricDataGenerator.createPack();
    }

    @Override
    public @NotNull class_2403 getVanillaGenerator() {
        return fabricDataGenerator;
    }

    @Override
    public <T extends class_2405> T addProvider(class_2405.@NotNull class_7857<T> factory) {
        return pack.addProvider(factory);
    }

    @Override
    public <T extends class_2405> T addProvider(@NotNull BiFunction<class_7784, CompletableFuture<class_7225.class_7874>, T> dataProviderSupplier) {
        return pack.addProvider(dataProviderSupplier::apply);
    }

    @Override
    public Mod getMod() {
        return Platform.getMod(fabricDataGenerator.getModId());
    }

    @Override
    public class_2446 createRecipeProvider(class_7784 packOutput, RecipeProviderWrapper recipeProviderWrapper) {
        return new WrappedFabricRecipeProvider((FabricDataOutput) packOutput, recipeProviderWrapper);
    }

    @Override
    public class_2474<class_1792> createItemTagProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookup, ItemTagProviderWrapper itemTagProviderWrapper, @NotNull BlockTagProviderWrapper blockTagProviderWrapper) {
        var blockTagsProvider = blockTagProviderWrapper.getProvider();
        if (!(blockTagsProvider instanceof FabricTagProvider.BlockTagProvider blockTagProvider))
            throw new IllegalArgumentException("Not FabricTagProvider.BlockTagProvider");
        return new WrappedFabricItemTagProvider((FabricDataOutput) packOutput, lookup, blockTagProvider, itemTagProviderWrapper);
    }

    @Override
    public class_2474<class_3611> createFluidTagProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookup, FluidTagProviderWrapper fluidTagProviderWrapper) {
        return new WrappedFabricFluidTagProvider((FabricDataOutput) packOutput, lookup, fluidTagProviderWrapper);
    }

    @Override
    public class_2474<class_2248> createBlockTagProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookup, BlockTagProviderWrapper blockTagProviderWrapper) {
        return new WrappedFabricBlockTagProvider((FabricDataOutput) packOutput, lookup, blockTagProviderWrapper);
    }

    @Override
    public class_2474<class_4158> createPoiTypeTagProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookup, PoiTypeTagProviderWrapper poiTypeTagProviderWrapper) {
        return new WrappedFabricPoiTypeTagProvider((FabricDataOutput) packOutput, lookup, poiTypeTagProviderWrapper);
    }

    @Override
    public class_2474<class_8110> createDamageTypeTagProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookup, DamageTypeTagsProviderWrapper damageTypeTagsProviderWrapper) {
        return new WrappedFabricDamageTypeTagProvider((FabricDataOutput) packOutput, lookup, damageTypeTagsProviderWrapper);
    }

    @Override
    public class_2405 createBasicProvider(BasicProviderWrapper basicProviderWrapper) {
        return new WrappedFabricBasicProvider(basicProviderWrapper);
    }

    @Override
    public class_2405 createBlockLootTableProvider(class_7784 packOutput, BlockLootTableProviderWrapper blockLootTableProviderWrapper) {
        return new WrappedFabricBlockLootTableProvider((FabricDataOutput) packOutput, blockLootTableProviderWrapper);
    }

    @Override
    public class_2405 createAdvancementProvider(class_7784 packOutput, AdvancementProviderWrapper advancementProviderWrapper, List<AdvancementSubProviderWrapper> subProviderWrappers) {
        return new WrappedFabricAdvancementProvider((FabricDataOutput) packOutput, advancementProviderWrapper, subProviderWrappers);
    }

    @Override
    public class_2405 createItemModelProvider(class_7784 packOutput, ItemModelProviderWrapper itemModelProviderWrapper) {
        return new WrappedFabricItemModelProvider((FabricDataOutput) packOutput, itemModelProviderWrapper);
    }

    @Override
    public class_2405 createBlockStateAndModelProvider(class_7784 packOutput, BlockStateAndModelProviderWrapper blockStateAndModelProviderWrapper) {
        return new WrappedFabricBlockModelProvider((FabricDataOutput) packOutput, this, blockStateAndModelProviderWrapper);
    }

    @Override
    public class_5475 createRegistriesDatapackGenerator(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookup, class_7877 registrySetBuilder) {
        return new WrappedRegistriesDatapackGenerator(packOutput, lookup, registrySetBuilder);
    }

    @Override
    public Collection<Path> getResourceInputFolders() {
        return ImmutableList.copyOf(resourceInputFolders);
    }

    @Override
    public void addResourceInputFolders(Path path) {
        resourceInputFolders.add(path);
    }
}
