package dev.felnull.otyacraftengine.server.level;

import net.minecraft.class_2487;

/**
 * NBTタグに保存やNBTタグから読み込むことができる実装
 *
 * @author MORIMORI0317
 */
public interface TagSerializable {
    void save(class_2487 tag);

    void load(class_2487 tag);

    default class_2487 createSavedTag() {
        var t = new class_2487();
        save(t);
        return t;
    }

    static <T extends TagSerializable> T loadSavedTag(class_2487 tag, T serializable) {
        serializable.load(tag);
        return serializable;
    }
}
