package dev.felnull.otyacraftengine.tag;

import dev.felnull.otyacraftengine.data.provider.IntrinsicHolderTagsProviderWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_6862;

public interface ManualTagHolder<T> {
    @NotNull
    static <T> ManualTagHolder<T> of(@NotNull class_6862<T> tagKey, @Nullable Consumer<IntrinsicHolderTagsProviderWrapper.IntrinsicTagAppenderWrapper<T>> tagRegister) {
        return new ManualTagHolderImpl<>(tagKey, tagRegister);
    }

    @NotNull
    static <T> ManualTagHolder<T> of(@NotNull class_6862<T> tagKey) {
        return new ManualTagHolderImpl<>(tagKey);
    }

    @NotNull
    static <T> ManualTagHolder<T> of(@NotNull Supplier<class_6862<T>> tagKey) {
        return new ManualTagHolder<>() {
            @Override
            public @NotNull class_6862<T> getKey() {
                return tagKey.get();
            }

            @Override
            public void registering(IntrinsicHolderTagsProviderWrapper.IntrinsicTagProviderAccess<T> tagProviderAccess) {
            }
        };
    }

    @NotNull
    class_6862<T> getKey();

    void registering(@NotNull IntrinsicHolderTagsProviderWrapper.IntrinsicTagProviderAccess<T> tagProviderAccess);
}
