package dev.felnull.otyacraftengine.util;

import dev.felnull.otyacraftengine.explatform.OEExpectPlatform;
import org.jetbrains.annotations.NotNull;

import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_6862;

/**
 * エンティテ関係のユーティリティ
 *
 * @author MORIMORI0317
 */
public final class OEEntityUtils {
    /**
     * エンティティタイプからタグのストリームを取得
     *
     * @param entityType エンティティタイプ
     * @return タグストリーム
     */
    @NotNull
    public static Stream<class_6862<class_1299<?>>> getTags(@NotNull class_1299<?> entityType) {
        return OEExpectPlatform.getTags(entityType);
    }

    /**
     * エンティティの腕からメインハンドかオフハンドか取得する
     *
     * @param entity 対象エンティティ
     * @param arm    腕
     * @return メインハンドもしくはオフハンド
     */
    @NotNull
    public static class_1268 getHandByArm(@NotNull class_1309 entity, @NotNull class_1306 arm) {
        Objects.requireNonNull(arm);
        return entity.method_6068() == arm ? class_1268.field_5808 : class_1268.field_5810;
    }

    /**
     * エンティティのメインハンドもしくはオフハンドから腕を取得
     *
     * @param entity 対象エンティティ
     * @param hand   メインハンドかオフハンド
     * @return 腕
     */
    @NotNull
    public static class_1306 getArmByHand(@NotNull class_1309 entity, @NotNull class_1268 hand) {
        Objects.requireNonNull(hand);
        return hand == class_1268.field_5808 ? entity.method_6068() : entity.method_6068().method_5928();
    }

    /**
     * メインハンドもしくはオフハンドの逆側を取得
     *
     * @param hand メインハンドもしくはオフハンド
     * @return 逆
     */
    @NotNull
    public static class_1268 getOppositeHand(@NotNull class_1268 hand) {
        Objects.requireNonNull(hand);
        return hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
    }
}
