package dev.felnull.otyacraftengine.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.felnull.otyacraftengine.client.gui.TextureRegion;
import dev.felnull.otyacraftengine.client.gui.components.base.OEBaseComponent;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class IconButton extends class_4185 implements OEBaseComponent {
    @NotNull
    private TextureRegion texture;

    public IconButton(int x, int y, int width, int height, class_2561 message, class_4241 onPress, @NotNull TextureRegion texture) {
        this(x, y, width, height, message, onPress, Supplier::get, texture);
    }

    public IconButton(int x, int y, int width, int height, class_2561 message, class_4241 onPress, class_7841 createNarration, @NotNull TextureRegion texture) {
        super(x, y, width, height, message, onPress, createNarration);
        this.texture = texture;
    }

    @Override
    public @NotNull TextureRegion getTexture() {
        return texture;
    }

    @Override
    public void setTexture(@NotNull TextureRegion texture) {
        this.texture = texture;
    }

    @Override
    public @Nullable String getWidgetTypeName() {
        return "iconButton";
    }

    @Override
    public void method_48579(class_332 guiGraphics, int i, int j, float f) {
       /* RenderSystem.setShaderTexture(0, WIDGETS_LOCATION);
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        blitNineSliced(poseStack, this.getX(), this.getY(), this.getWidth(), this.getHeight(), 20, 4, 200, 20, 0, this.getTextureY());
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);*/

        guiGraphics.method_51422(1.0F, 1.0F, 1.0F, this.field_22765);
        guiGraphics.method_49697(field_22757, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 20, 4, 200, 20, 0, this.method_49602());
        guiGraphics.method_51422(1.0F, 1.0F, 1.0F, 1.0F);

        renderIcon(guiGraphics, i, j, f);
    }

    private int method_49602() {
        int i = 1;
        if (!this.field_22763) {
            i = 0;
        } else if (this.method_25367()) {
            i = 2;
        }

        return 46 + i * 20;
    }

    protected void renderIcon(@NotNull class_332 guiGraphics, int i, int j, float f) {
        RenderSystem.setShaderTexture(0, getTexture().location());
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, this.field_22765);
        OERenderUtils.blitFloat(guiGraphics.method_51448(), method_46426() + (field_22758 - texture.uvWidth()) / 2f, method_46427() + (field_22759 - texture.uvHeight()) / 2f, getTexture().u0(), getTexture().v0(), getTexture().uvWidth(), getTexture().uvHeight(), getTexture().width(), getTexture().height());
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
    }
}
