package dev.felnull.otyacraftengine.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.felnull.otyacraftengine.client.gui.TextureRegion;
import dev.felnull.otyacraftengine.client.gui.components.base.OEBasedButton;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class RadioButton extends OEBasedButton {
    @Nullable
    private final Consumer<RadioButton> onToggle;
    @NotNull
    private final Supplier<Set<RadioButton>> group;
    private boolean showLabel;
    private boolean selected;

    public RadioButton(int x, int y, @NotNull class_2561 message, @Nullable Consumer<RadioButton> onPress, @NotNull Supplier<Set<RadioButton>> group, boolean showLabel) {
        this(x, y, 20, 20, message, onPress, group, showLabel, TextureRegion.relative(OE_WIDGETS, 0, 0, 20, 20));
    }

    public RadioButton(int x, int y, int width, int height, @NotNull class_2561 message, @Nullable Consumer<RadioButton> onPress, @NotNull Supplier<Set<RadioButton>> group, boolean showLabel, @NotNull TextureRegion texture) {
        super(x, y, width, height, message, "radioButton", texture);
        this.onToggle = onPress;
        this.group = group;
        this.showLabel = showLabel;
    }

    @Override
    public void method_25306() {
        this.selected = true;
        for (RadioButton rdo : group.get()) {
            if (this != rdo) rdo.selected = false;
        }
        if (onToggle != null) this.onToggle.accept(this);
    }

    public boolean isSelected() {
        return selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public void method_48579(class_332 guiGraphics, int i, int j, float f) {
        class_310 minecraft = class_310.method_1551();
        RenderSystem.setShaderTexture(0, getTexture().location());
        RenderSystem.enableDepthTest();
        class_327 font = minecraft.field_1772;
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, this.field_22765);
        OERenderUtils.blitFloat(guiGraphics.method_51448(), method_46426(), method_46427(), getTexture().u0() + (this.method_25367() ? 20 : 0), getTexture().v0() + (this.selected ? 20 : 0), getTexture().uvWidth(), getTexture().uvHeight(), getTexture().width(), getTexture().height());

        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
        if (this.showLabel) {
//            drawString(poseStack, font, this.getMessage(), this.getX() + 24, this.getY() + (this.height - 8) / 2, 14737632 | Mth.ceil(this.alpha * 255.0F) << 24);
            guiGraphics.method_27535(font, this.method_25369(), this.method_46426() + 24, this.method_46427() + (this.field_22759 - 8) / 2, 14737632 | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
        }

    }
}
