package dev.felnull.otyacraftengine.data.provider;

import dev.felnull.fnjl.util.FNStringUtil;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class InputBaseProviderWrapper extends BasicProviderWrapper {
    protected final class_7784.class_7489 pathProvider;
    protected final class_7784.class_7490 target;
    protected final String modId;
    protected final String kind;

    public InputBaseProviderWrapper(class_7784 packOutput, class_7784.class_7490 target, String kind, CrossDataGeneratorAccess crossDataGeneratorAccess) {
        this(packOutput, target, crossDataGeneratorAccess.getMod().getModId(), kind, crossDataGeneratorAccess);
    }

    public InputBaseProviderWrapper(class_7784 packOutput, class_7784.class_7490 target, String modId, String kind, CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(packOutput, crossDataGeneratorAccess);
        this.pathProvider = packOutput.method_45973(target, kind);
        this.target = target;
        this.modId = modId;
        this.kind = kind;
    }

    @Override
    public CompletableFuture<?> run(class_7403 cachedOutput) {
        List<CompletableFuture<?>> tasks = new ArrayList<>();
        var inPaths = getCrossGeneratorAccess().getResourceInputFolders();

        for (Path inPath : inPaths) {
            var targetPath = inPath.resolve(targetByName(target)).resolve(modId).resolve(kind);
            if (!Files.exists(targetPath))
                continue;

            try (var walk = Files.walk(targetPath)) {
                walk.forEach(path -> {
                    if (Files.isDirectory(path))
                        return;

                    if (!isTarget(inPath, path))
                        return;

                    var task = runTask(cachedOutput, inPath, path);
                    if (task != null)
                        tasks.add(task);
                });
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        return CompletableFuture.allOf(tasks.toArray(CompletableFuture[]::new));
    }

    protected abstract boolean isTarget(Path rootPath, Path targetPath);

    @Nullable
    protected abstract CompletableFuture<?> runTask(class_7403 cachedOutput, Path inputRoot, Path target);

    private static String targetByName(class_7784.class_7490 target) {
        switch (target) {
            case field_39367 -> {
                return "data";
            }
            case field_39368 -> {
                return "assets";
            }
            case field_39369 -> {
                return "reports";
            }
        }
        throw new RuntimeException("Unexpected target.");
    }

    protected Pair<class_2960, String> toResourceLocationAndExtension(Path inputRoot, Path target) {
        var relativePath = inputRoot.relativize(target);

        var sb = new StringBuilder();
        String ex = "";

        for (int i = 0; i < relativePath.getNameCount() - 3; i++) {
            var p = relativePath.getName(i + 3).toFile().getName();
            if (i == relativePath.getNameCount() - 4) {
                sb.append(FNStringUtil.removeExtension(p));
                ex = FNStringUtil.getExtension(p);
            } else {
                sb.append(p).append("/");
            }
        }

        return Pair.of(new class_2960(relativePath.getName(1).toFile().getName(), sb.toString()), ex);
    }
}
