package dev.felnull.otyacraftengine.fabric.data.provider;

import dev.felnull.otyacraftengine.data.provider.FluidTagProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.IntrinsicHolderTagsProviderWrapper;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import java.util.concurrent.CompletableFuture;

public class WrappedFabricFluidTagProvider extends FabricTagProvider.FluidTagProvider {
    private final FluidTagProviderWrapper fluidTagProviderWrapper;

    public WrappedFabricFluidTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture, FluidTagProviderWrapper fluidTagProviderWrapper) {
        super(output, completableFuture);
        this.fluidTagProviderWrapper = fluidTagProviderWrapper;
    }

    @Override
    protected void addTags(class_7225.class_7874 arg) {
        this.fluidTagProviderWrapper.generateTag(new FluidTagProviderAccessImpl());
    }

    private class FluidTagProviderAccessImpl implements IntrinsicHolderTagsProviderWrapper.IntrinsicTagProviderAccess<class_3611> {
        @Override
        public IntrinsicHolderTagsProviderWrapper.IntrinsicTagAppenderWrapper<class_3611> tag(class_6862<class_3611> tagKey) {
            return new WrappedFabricIntrinsicHolderTagsProvider.IntrinsicHolderTagAppenderWrapperImpl<>(WrappedFabricFluidTagProvider.this.tag(tagKey), fluidTagProviderWrapper);
        }
    }
}
