package dev.felnull.otyacraftengine.util;

import com.google.common.collect.ImmutableList;
import dev.felnull.otyacraftengine.explatform.OEExpectPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1785;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_4174;

/**
 * アイテム関係のユーティリティ
 *
 * @author MORIMORI0317
 */
public final class OEItemUtils {
    /**
     * MOBバケツから中身のエンティティタイプを取得
     *
     * @param item MOBバケツのアイテム
     * @return アイテムスタック
     */
    public static class_1299<?> getMobBucketEntity(@NotNull class_1785 item) {
        return OEExpectPlatform.getMobBucketEntity(item);
    }

    /**
     * アイテムスタックをコピーして、スタック数を制定する
     *
     * @param itemStack アイテムスタック
     * @param size      スタック数
     * @return コピーずみアイテムスタック
     */
    @NotNull
    public static class_1799 copyAndSetCount(@NotNull class_1799 itemStack, int size) {
        if (size == 0)
            return class_1799.field_8037;
        class_1799 copy = itemStack.method_7972();
        copy.method_7939(size);
        return copy;
    }

    @NotNull
    public static class_1799 createMoriMoriHead() {
        return createPlayerHead("MoriMori_0317_jp");
    }

    @NotNull
    public static class_1799 createKamesutaHead() {
        return createPlayerHead("kamesuta");
    }

    @NotNull
    public static class_1799 createNinHead() {
        return createPlayerHead("nin8995");
    }

    @NotNull
    public static class_1799 createMGHead() {
        return createPlayerHead("MultiGamer8853");
    }

    @NotNull
    public static class_1799 createMiyabiHead() {
        return createPlayerHead("miyabi0333");
    }

    @NotNull
    public static class_1799 createYuuHead() {
        return createPlayerHead("yuu_111");
    }

    @NotNull
    public static class_1799 createToranpfanHead() {
        return createPlayerHead("toranpfan6433");
    }

    @NotNull
    public static class_1799 createHarumakiHead() {
        return createPlayerHead("Harumaki_jp");
    }

    @NotNull
    public static class_1799 createBuunnHead() {
        return createPlayerHead("yamane_buunn0921");
    }

    @NotNull
    public static class_1799 createMUHead() {
        return createPlayerHead("MU_2525");
    }

    @NotNull
    public static class_1799 createAlfortHead() {
        return createPlayerHead("Alfort121R");
    }

    /**
     * プレイヤーの頭のアイテムスタックを作成
     *
     * @param player プレイヤー
     * @return 頭のアイテムスタック
     */
    @NotNull
    public static class_1799 createPlayerHead(@NotNull class_1657 player) {
        return createPlayerHead(player.method_7334().getName());
    }

    /**
     * プレイヤーの頭のアイテムスタックを作成
     *
     * @param name プレイヤー名
     * @return 頭のアイテムスタック
     */
    @NotNull
    public static class_1799 createPlayerHead(@NotNull String name) {
        class_1799 playerhead = new class_1799(class_1802.field_8575);
        class_2487 tag = playerhead.method_7948();
        tag.method_10582("SkullOwner", name);
        return playerhead;
    }

    /**
     * アイテムスタックエンティティを作成
     *
     * @param item  アイテムスタック
     * @param level レベル
     * @param pos   座標
     * @return アイテムスタックエンティティ
     */
    @NotNull
    public static class_1542 createItemEntity(@NotNull class_1799 item, @NotNull class_1937 level, class_243 pos) {
        return createItemEntity(item, level, pos.method_10216(), pos.method_10214(), pos.method_10215());
    }

    /**
     * アイテムスタックエンティティを作成
     *
     * @param item  アイテムスタック
     * @param level レベル
     * @param x     座標X
     * @param y     座標Y
     * @param z     座標Z
     * @return アイテムスタックエンティティ
     */
    @NotNull
    public static class_1542 createItemEntity(@NotNull class_1799 item, @NotNull class_1937 level, double x, double y, double z) {
        class_1542 iteme = new class_1542(level, x, y, z, item);
        iteme.method_6988();
        return iteme;
    }

    /**
     * 指定の数だけのスタックされたアイテムスタックのリストを用意する
     *
     * @param stack アイテムスタック
     * @param cont  　数
     * @return アイテムスタックのリスト
     */
    @NotNull
    public static List<class_1799> allocationItemStack(@NotNull class_1799 stack, int cont) {
        if (stack.method_7960()) return ImmutableList.of();
        List<class_1799> stacks = new ArrayList<>();
        int sc = stack.method_7914();
        int ct = cont / sc;
        int am = cont - ct * sc;
        for (int i = 0; i < ct; i++) {
            var st = stack.method_7972();
            st.method_7939(sc);
            stacks.add(st);
        }
        if (am != 0) {
            var st = stack.method_7972();
            st.method_7939(am);
            stacks.add(st);
        }
        return ImmutableList.copyOf(stacks);
    }

    /**
     * アイテムスタックからMODIDを取得
     *
     * @param stack アイテムスタック
     * @return MODID
     */
    public static String getCreatorModId(@NotNull class_1799 stack) {
        return OEExpectPlatform.getItemCreatorModId(stack);
    }

    /**
     * スタック数を除いて一致するかどうか
     *
     * @param stack1 アイテムスタック
     * @param stack2 アイテムスタック
     * @return 一致するかどうか
     */
    public static boolean matchesExceptStackCount(@NotNull class_1799 stack1, @NotNull class_1799 stack2) {
        if (stack1.method_7960() && stack2.method_7960())
            return true;

        if (!stack1.method_31574((stack2.method_7909())))
            return false;

        if (!stack1.method_7960() && !stack2.method_7960())
            return class_1799.method_31577(stack1, stack2);

        return false;
    }

    /**
     * アイテムスタックのリストを最適化する<br>
     * スタック可能なアイテムをスタックし、空のアイテムスタックを削除
     *
     * @param stacks アイテムスタックリスト
     * @return 最適化済みアイテムスタックリスト
     */
    @NotNull
    public static List<class_1799> overlapItemStacks(@NotNull List<class_1799> stacks) {
        List<class_1799> ret = new ArrayList<>();

        for (class_1799 stack : stacks) {
            if (stack.method_7960())
                continue;

            class_1799 match = null;
            for (class_1799 retstack : ret) {
                if (retstack.method_7947() < retstack.method_7914() && matchesExceptStackCount(stack, retstack)) {
                    match = retstack;
                    break;
                }
            }

            if (match == null) {
                ret.add(stack.method_7972());
            } else {
                int c = match.method_7947() + stack.method_7947();
                int mc = match.method_7914();
                if (c <= mc) {
                    match.method_7939(c);
                } else {
                    match.method_7939(mc);
                    class_1799 ns = stack.method_7972();
                    ns.method_7939(c - mc);
                    ret.add(ns);
                }
            }
        }

        return ret;
    }

    @Nullable
    public static class_4174 getFoodProperties(class_1799 stack, @Nullable class_1309 livingEntity) {
        return OEExpectPlatform.getFoodProperties(stack, livingEntity);
    }
}
